from sandbox.projects import resource_types
from sandbox.projects.gencfg import resource_types as sdk2_resource_types
import sandbox.common.types.resource as ctr
import sandbox.projects.images.basesearch.resources as images_resources
import sandbox.projects.images.ImagesTestSaasBasics as saas_basics
from sandbox import sdk2

from sandbox.sandboxsdk.process import run_process


class RunImagesQuickFusionProductionEnv(saas_basics.RunFusionProductionEnvBase):
    class Parameters(saas_basics.RunFusionProductionEnvBase.Parameters):
        sw_config = sdk2.parameters.Resource(
            'shard writer config',
            resource_type=resource_types.IMAGES_SHARDWRITER_CONFIG,
            state=(ctr.State.READY, ),
            required=False,
        )

        gen_cfg = sdk2.parameters.Resource(
            'gen cfg bundle',
            resource_type=sdk2_resource_types.CONFIG_GENERATOR_CONFIGS_TGZ,
            state=(ctr.State.READY, ),
            required=False,
        )

        rtyserver_configs_bundle = sdk2.parameters.Resource(
            'rtyserver_configs_bundle',
            resource_type=images_resources.IMGQUICK_SAAS_RTYSERVER_CONFIGS_BUNDLE,
            state=(ctr.State.READY, ),
            required=False,
        )

        frequent_keys = sdk2.parameters.Resource(
            'frequent_keys.txt resource',
            resource_type=resource_types.OTHER_RESOURCE,
            state=(ctr.State.READY, ),
            required=True,
            default_value=1105170671
        )

    def make_local_fixes(self):
        super(RunImagesQuickFusionProductionEnv, self).make_local_fixes()
        run_process(["tar", "zxf", self.obtained_resources['gen_cfg'], "--strip-components=1", "all/quick_distributors.conf"], log_prefix="tar_log")

    def get_extra_params(self):
        base_extra_params = super(RunImagesQuickFusionProductionEnv, self).get_extra_params()
        base_extra_params["SHARDWRITER_CONFIG"] = self.obtained_resources['sw_config']
        base_extra_params["ThreadsMult"] = 1
        base_extra_params["FREQUENT_KEYS_PATH"] = self.obtained_resources['frequent_keys']
        return base_extra_params
