# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.parameters import SandboxIntegerParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.sandboxsdk.parameters import TaskSelector

from sandbox.projects import resource_types
from sandbox.projects import GetImagesMrIndexConfig as mr_index_config
from sandbox.projects.common import utils
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.gencfg import api_client as gencfg_api
from sandbox.projects.common.search import settings as media_settings

from sandbox.projects.images import responses as images_responses
from sandbox.projects.images import ImagesBuildSearchBinary as build_base
from sandbox.projects.images import ImagesUploadSaas as upload_saas
from sandbox.projects.images import ImagesGetSaasResponses as  saas_responses
from sandbox.projects.images.models import ImagesBuildDynamicModels as build_models
from sandbox.projects.images.resources import task as images_resources_tasks

import sandbox.common.types.task as ctt

from . import component

_TESTING_BINARY_GROUP = "Testing binary params"
SEMAPHORE_CAPACITY = 1


class ImagesBuildBasesearchTaskParameter(TaskSelector):
    """
        Таск со сборкой картиночного базового поиска
    """
    name = 'images_build_basesearch_task_parameter'
    description = 'Таск со сборкой картиночного базового поиска'
    task_type = [build_base.ImagesBuildSearchBinary.type]
    group = _TESTING_BINARY_GROUP


class ImagesBuildDynamicModelsTaskParameter(TaskSelector):
    """
        Таск с моделями для базового поиска
    """
    name = 'images_build_dynamic_models_task_parameter'
    description = 'Таск с моделями для базового поиска'
    task_type = [build_models.ImagesBuildDynamicModels.type]
    group = _TESTING_BINARY_GROUP


class GetImagesMrIndexConfigTaskParameter(TaskSelector):
    """
        Таск со сборкой shardwriter_config
    """
    name = 'get_images_mr_index_config_task_parameter'
    description = 'Таск со сборкой shardwriter_config'
    task_type = [mr_index_config.GetImagesMrIndexConfig.type]
    group = _TESTING_BINARY_GROUP


_NANNY_GROUP = "Nanny params"


class NannySaasBaseServiceNameParameter(SandboxStringParameter):
    """
        Название production сервиса с базовыми saas
    """
    name = 'saas_base_nanny_service_name'
    description = 'Название production сервиса с базовыми saas'
    default_value = 'prod-imgs-quick-base-vla'
    group = _NANNY_GROUP


class NannySaasDistributorServiceNameParameter(SandboxStringParameter):
    """
        Название production сервиса с distributor saas
    """
    name = 'saas_distributor_nanny_service_name'
    description = 'Название production сервиса с distributor saas (deprecated)'
    default_value = 'saas_refresh_production_images_distributors'
    group = _NANNY_GROUP


class NannySaasProxyServiceNameParameter(SandboxStringParameter):
    """
        Название production сервиса с proxy saas
    """
    name = 'saas_proxy_nanny_service_name'
    description = 'Название production сервиса с proxy saas (deprecated)'
    default_value = 'saas_refresh_production_images_indexerproxy'
    group = _NANNY_GROUP


class NannySaasTestingBaseServiceNameParameter(SandboxStringParameter):
    """
        Название testing сервиса с базовыми saas
    """
    name = 'saas_base_nanny_service_tesing_name'
    description = 'Название testing сервиса с базовыми saas'
    default_value = 'saas-refresh-production-images-base-test-yp'
    group = _NANNY_GROUP


class NannySaasTestingDistributorServiceNameParameter(SandboxStringParameter):
    """
        Название testing сервиса с distributor saas
    """
    name = 'saas_distributor_nanny_tesing_service_name'
    description = 'Название testing сервиса с distributor saas (deprecated)'
    default_value = 'saas_refresh_production_images_distributors_test'
    group = _NANNY_GROUP


class NannySaasTestingProxyServiceNameParameter(SandboxStringParameter):
    """
        Название testing сервиса с proxy saas
    """
    name = 'saas_proxy_nanny_tesing_service_name'
    description = 'Название testing сервиса с proxy saas (deprecated)'
    default_value = 'saas_refresh_production_images_indexerproxy_test'
    group = _NANNY_GROUP


class NannySaasBaseTestGenCfgGroupNameParameter(SandboxStringParameter):
    """
        Название группы в gencfg для тестовых базовых saas
    """
    name = 'saas_base_test_gencfg_group_name'
    description = 'Название группы в gencfg для тестовых базовых saas'
    default_value = 'MAN_IMGS_ULTRA_BASE_TEST'


class NannySaasDistributorTestGenCfgGroupNameParameter(SandboxStringParameter):
    """
        Название группы в gencfg для тестовых distributor saas
    """
    name = 'saas_distributor_test_gencfg_group_name'
    description = 'Название группы в gencfg для тестовых distributor saas (deprecated)'
    default_value = 'MAN_IMGS_ULTRA_REFRESH_DISTRIBUTOR_TEST'
    group = _NANNY_GROUP


class NannySaasProxyTestGenCfgGroupNameParameter(SandboxStringParameter):
    """
        Название группы в gencfg для тестовых proxy saas
    """
    name = 'saas_proxy_test_gencfg_group_name'
    description = 'Название группы в gencfg для тестовых proxy saas (deprecated)'
    default_value = 'MAN_IMGS_INDEXER_PROXY_TEST'
    group = _NANNY_GROUP


class NannySaasRtyServerTestConfigFileNameParameter(SandboxStringParameter):
    """
        Имя файла с rtyserver.conf для тестового контура (берется из gencfg)
    """
    name = 'saas_rtyserver_test_config_filename'
    description = 'Имя файла с rtyserver.conf для тестового контура (берется из gencfg)'
    default_value = 'images-saas-rtyserver-test.conf'
    group = _NANNY_GROUP


class NannySaasProxyTestSearchMapFileNameParameter(SandboxStringParameter):
    """
        Имя файла с searchmap.json для тестового контура (берется из gencfg)
    """
    name = 'saas_proxy_test_searchmap_filename'
    description = 'Имя файла с searchmap.json для тестового контура (берется из gencfg)'
    default_value = 'images-saas-indexerproxy-test.json'
    group = _NANNY_GROUP


class NannyActivateTimeoutParameter(SandboxIntegerParameter):
    """
        Таймаут на время активации сервисов в nanny в секундах
    """
    name = 'saas_nanny_services_activation_timeout'
    description = 'Таймаут на время активации сервисов в nanny в секундах'
    default_value = '7200'
    group = _NANNY_GROUP


class NannySaasCategoryNameParameter(SandboxStringParameter):
    """
        Категория, в которой будут находятся приемочные сервисы в nanny
    """
    name = 'saas_category_name'
    description = 'Категория, в которой находятся приемочные сервисы в nanny'
    default_value = '/images/saas/priemka'
    group = _NANNY_GROUP


class NannySaasSSDClearCacheScriptParameter(SandboxStringParameter):
    """
        Shell скрипт для очистки /ssd/webchache/<instance_dir> в nanny
    """
    name = 'ssd_clear_cache_script'
    description = 'Shell скрипт для очистки /ssd/webchache/<instance_dir> в nanny'
    default_value = 'https://proxy.sandbox.yandex-team.ru/182100151'
    group = _NANNY_GROUP


_SAAS_UPLOAD_GROUP = "Saas upload params"


class SaasSleepTimeParameter(SandboxIntegerParameter):
    """
        Время ожидания перед выполнением обстрела для раскатки индекса в saas
    """
    name = 'sleeping_time_before_getting_responses'
    description = 'Время ожидания перед выполнением обстрела для раскатки индекса в saas'
    default_value = '900'
    group = _SAAS_UPLOAD_GROUP


class QueriesParameter(images_responses.RESPONSE_SAVER_PARAMS.QueriesParameter):
    """
        Запросы для обстрела
    """
    required = False


class QueriesLimitParameter(images_responses.RESPONSE_SAVER_PARAMS.QueriesLimitParameter):
    """
        Лимит запросов для обстрела
    """
    default_value = 10000
    required = False


class MaxEmptyResponsesRate(images_responses.MaxEmptyResponsesRate):
    """
        Допустимая доля пустых ответов
    """
    default_value = 0.80


_NANNY_SERVICE_PRIEMKA = "images_nanny_services_priemka"
_SAAS_UPLOAD_TASK = 'saas_upload_task'
_BASE_SEARCH_RESPONSES_TASK = 'get_remote_base_search_responses'
_TESTING_QUERIES_TYPE = "testing_queries"


# It's not recommended to use. Needed for inheritance of ImagesQuickAcceptance
class ImagesUltraAcceptance(images_resources_tasks.ImagesProductionResourcesTask, SandboxTask):
    """
        Принимаем рантайм контур картиночной ультры
    """
    type = 'IMAGES_ULTRA_ACCEPTANCE'

    input_parameters = (
        ImagesBuildBasesearchTaskParameter,
        ImagesBuildDynamicModelsTaskParameter,
        GetImagesMrIndexConfigTaskParameter,
        NannySaasBaseServiceNameParameter,
        NannySaasTestingBaseServiceNameParameter,
        NannySaasBaseTestGenCfgGroupNameParameter,
        NannyActivateTimeoutParameter,
        NannySaasRtyServerTestConfigFileNameParameter,
        NannySaasProxyTestSearchMapFileNameParameter,
        NannySaasCategoryNameParameter,
        NannySaasSSDClearCacheScriptParameter,
        SaasSleepTimeParameter,
        QueriesLimitParameter,
        MaxEmptyResponsesRate,
    ) + upload_saas.ImagesUploadSaas.input_parameters

    # export names in stx for easy creating subtask
    LIMIT_SE_TAG = '/images/ultra/acceptance/'
    BINARY_TASK = ImagesBuildBasesearchTaskParameter.name

    RESPONSES_STATS_KEY = saas_responses.ImagesGetSaasResponses.RESPONSES_STATS_KEY

    @staticmethod
    def __get_released_resource(resource_type, release_status):
        return channel.sandbox.list_releases(
            resource_type=resource_type,
            limit=1,
            release_status=release_status
        )[0].resources[0].id

    @staticmethod
    def __get_stable_saas_index_location():
        return ImagesUltraAcceptance.__get_released_resource(resource_types.IMAGES_INDEX_LOCATION, 'stable')

    @staticmethod
    def __get_stable_upload_saas():
        return ImagesUltraAcceptance.__get_released_resource(resource_types.IMAGES_UPLOADSAAS_EXECUTABLE, 'stable')

    def __run_saas_upload(self, saas_proxy):
        subtask_ctx = {
            upload_saas.ImagesUploadSaas.INDEX_LOCATION:
                self.__get_stable_saas_index_location(),
            upload_saas.ImagesUploadSaas.SAAS_BASESEARCH_SERVER:
                saas_proxy,
            upload_saas.ImagesUploadSaas.UPLOAD_SAAS_BIN:
                self.__get_stable_upload_saas()
        }

        task = channel.task.create_subtask(
            task_type=upload_saas.ImagesUploadSaas.type,
            description=self.descr,
            input_parameters=subtask_ctx)

        self.ctx[_SAAS_UPLOAD_TASK] = task.id

    def __find_last_testing_queries(self):
        return self._get_middlesearch_queries(media_settings.INDEX_MIDDLE, self.ctx[_TESTING_QUERIES_TYPE])

    def __run_get_basesearch_reponses(self, remote_basesearch):
        subtask_ctx = {
            saas_responses.ImagesGetSaasResponses.SAAS_BASE_SEARCH_URL:
                remote_basesearch,
            saas_responses.ImagesGetSaasResponses.QUERIES_SOURCE:
                utils.get_or_default(self.ctx, QueriesParameter) or self.__find_last_testing_queries(),
            saas_responses.ImagesGetSaasResponses.QUERIES_LIMIT:
                utils.get_or_default(self.ctx, QueriesLimitParameter),
            saas_responses.ImagesGetSaasResponses.QUERIES_EMPTY_LIMIT:
                utils.get_or_default(self.ctx, MaxEmptyResponsesRate),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_BINARY:
                self._get_middlesearch_executable(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_REARANGE_DATA:
                self._get_middlesearch_data(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_REARANGE_INDEX:
                self._get_middlesearch_index(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_MODELES:
                self._get_middlesearch_models(),
            saas_responses.ImagesGetSaasResponses.MIDDLESEARCH_CONFIG:
                self._get_middlesearch_config(),
        }

        task = channel.task.create_subtask(
            task_type=saas_responses.ImagesGetSaasResponses.type,
            description=self.descr,
            input_parameters=subtask_ctx)

        self.ctx[_BASE_SEARCH_RESPONSES_TASK] = task.id

    def __declare_nanny_service(self):
        nanny_client = nanny.NannyClient(
            api_url='http://nanny.yandex-team.ru/',
            oauth_token=self.get_vault_data('MEDIA_DEPLOY', 'nanny-oauth-token'),
        )

        gencfg = gencfg_api.GencfgApiClient('http://api.gencfg.yandex-team.ru')

        production_services = [
            self.ctx[NannySaasBaseServiceNameParameter.name],
        ]

        testing_services = [
            self.ctx[NannySaasTestingBaseServiceNameParameter.name],
        ]

        gencfg_groups = {
            self.ctx[NannySaasTestingBaseServiceNameParameter.name]: self.ctx[NannySaasBaseTestGenCfgGroupNameParameter.name],
        }

        config_files = {
            'rtyserver.conf-common': self.ctx[NannySaasRtyServerTestConfigFileNameParameter.name],
            'searchmap.json': self.ctx[NannySaasProxyTestSearchMapFileNameParameter.name]
        }

        service = component.RemoteNannySaasComponent(
                                self.id,
                                nanny_client=nanny_client,
                                gencfg=gencfg,
                                build_base_task=self.ctx[ImagesBuildBasesearchTaskParameter.name],
                                build_models_task=self.ctx[ImagesBuildDynamicModelsTaskParameter.name],
                                mr_index_config_task=self.ctx[GetImagesMrIndexConfigTaskParameter.name],
                                production_services=production_services,
                                testing_services=testing_services,
                                gencfg_groups=gencfg_groups,
                                config_files=config_files,
                                nanny_category=self.ctx[NannySaasCategoryNameParameter.name],
                                clear_cache_script=self.ctx[NannySaasSSDClearCacheScriptParameter.name],
                                activation_timeout=self.ctx[NannyActivateTimeoutParameter.name]
                            )

        return service

    def on_enqueue(self):
        SandboxTask.on_enqueue(self)
        self.semaphores(ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name=self.type, capacity=SEMAPHORE_CAPACITY)
            ]
        ))
        self.ctx[_TESTING_QUERIES_TYPE] = media_settings.INDEX_ULTRA

    def on_execute(self):
        with self.memoize_stage.wait_nanny(commit_on_entrance=False):
            service = self.__declare_nanny_service()
            tasks = service.find_running_tasks()
            if tasks:
                self.wait_all_tasks_stop_executing(tasks=tasks)

        with self.memoize_stage.run_nanny(commit_on_entrance=False):
            service = self.__declare_nanny_service()
            service.start()
            self.ctx[_NANNY_SERVICE_PRIEMKA] = service.get_test_services()

        with self.memoize_stage.wait_index_data:
            self.wait_time(self.ctx[SaasSleepTimeParameter.name])

        with self.memoize_stage.run_grab_responses(commit_on_entrance=False):
            service = self.__declare_nanny_service()
            service.set_test_services(self.ctx[_NANNY_SERVICE_PRIEMKA])
            proxy_instances = service.get_service_instance_urls(self.ctx[NannySaasTestingBaseServiceNameParameter.name])
            self.__run_get_basesearch_reponses(proxy_instances[0])

        with self.memoize_stage.wait_responses(commit_on_entrance=False):
            utils.wait_all_subtasks_stop()

        with self.memoize_stage.check_responses(commit_on_entrance=False):
            responses_task = channel.sandbox.get_task(self.ctx[_BASE_SEARCH_RESPONSES_TASK])
            self.ctx[self.RESPONSES_STATS_KEY] = responses_task.ctx.get(self.RESPONSES_STATS_KEY, {})

            utils.check_subtasks_fails(fail_on_first_failure=True)

        with self.memoize_stage.stop_service:
            service = self.__declare_nanny_service()
            service.set_test_services(self.ctx[_NANNY_SERVICE_PRIEMKA])
            service.stop()

    def on_finish(self):
        service = self.__declare_nanny_service()
        service.set_test_services(self.ctx[_NANNY_SERVICE_PRIEMKA])
        service.stop()


__Task__ = ImagesUltraAcceptance
