# -*- encoding: utf-8 -*-

import logging
import os
from sandbox import sdk2

from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.WizardRuntimeBuild.ya_make import YaMake

YaMake = YaMake.YaMake


class ImagesUpdateCommercialFilterSuggestWizardData(sdk2.Task):
    """
    Update data for commercial filter suggest in Yandex.Images
    """
    class Parameters(sdk2.Task.Parameters):
        arcadia_data_path = sdk2.parameters.String(
            'Arcadia data path',
            default=Arcadia.trunk_url('search/wizard/data/fresh/ImgCommercialFilterSuggest'),
        )
        resource_ids = sdk2.parameters.Dict(
            'Files with their resource ids',
            required=True,
        )
        commit_message = sdk2.parameters.String(
            'Commit message',
            required=True,
        )

    def on_execute(self):
        wizard_data_path = str(self.path("wizard_data"))
        Arcadia.checkout(self.Parameters.arcadia_data_path, wizard_data_path)

        yamakefile = os.path.join(wizard_data_path, 'ya.make')
        yamake = YaMake(yamakefile)
        for filename, resource_id in self.Parameters.resource_ids.iteritems():
            yamake.update_sandbox_resource(str(os.path.basename(filename)), resource_id, compression='FILE')
        with open(yamakefile, 'w') as y:
            yamake.dump(y)

        svn_status = Arcadia.status(wizard_data_path)
        if svn_status:
            Arcadia.commit(wizard_data_path, self.Parameters.commit_message, 'zomb-sandbox-rw')
        else:
            logging.info("No diff found")
