# -*- coding: utf-8 -*-_read_resource

import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.errors import SandboxTaskFailureError

import sandbox.sandboxsdk.copy as sdk_copy

SCRIPT = '__main__.py'
CONFIG = 'config.json'
SVN_PATH = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/extsearch/images/razladki/yt_razladki/'
SVN_SCRIPT = SVN_PATH + SCRIPT
SVN_CONFIG = SVN_PATH + CONFIG


class YtRazladki(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt')]
        cores = 1
        ram = 1024
        disk_space = 1024

    input_parameters = []

    def on_execute(self):
        sdk_copy.RemoteCopy(SVN_SCRIPT, SCRIPT, log_dir=self.log_path())()
        sdk_copy.RemoteCopy(SVN_CONFIG, CONFIG, log_dir=self.log_path())()

        oauth_token = sdk2.Vault.data('ak762_oauth_token')
        yt_token = sdk2.Vault.data('ak762_yt_token')

        os.environ['YT_TOKEN'] = yt_token
        os.environ['YT_RAZLADKI_OAUTH_TOKEN'] = oauth_token

        if subprocess.Popen(['/skynet/python/bin/python', SCRIPT, CONFIG], stderr=subprocess.STDOUT).wait() != 0:
            raise SandboxTaskFailureError("Error: subprocess failed")
