# -*- coding: utf-8 -*-

import os
import subprocess

from sandbox import sdk2

from sandbox import sandboxsdk

from sandbox.projects.images.balancer import resources as config_resources
from sandbox.projects.common.nanny import nanny


class ImagesBuildThumbBalancerConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Качаем тарболл с конфигами из gencfg и достаём от туда конфиги тумбового балансера
    """

    GENERATED_DIR = "custom_generators/balancer_gencfg/generated"

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        tag = sdk2.parameters.String('Tag name (e.g. stable-107-r100)')

        with sdk2.parameters.Group("Releasable configs"):
            default_configs = {
                config_resources.BALANCER_IMPROXY_IMAGES_SAS_CONFIG_2: "improxy/improxy_images_sas.cfg",
                config_resources.BALANCER_IMPROXY_IMAGES_VLA_CONFIG_2: "improxy/improxy_images_vla.cfg",
                config_resources.BALANCER_IMPROXY_IMAGES_MAN_CONFIG_2: "improxy/improxy_images_man.cfg",
                config_resources.BALANCER_IMPROXY_IMAGES_PRIEMKA_CONFIG_2: "improxy/improxy_images_priemka.cfg",
#                resources.ImagesConfigThumbPrestableBalancerSAS: "generated/improxy/improxy-prestable_sas.cfg",
#                resources.ImagesConfigThumbPrestableBalancerVLA: "generated/improxy/improxy-prestable_vla.cfg",
#                resources.ImagesConfigThumbPrestableBalancerMAN: "generated/improxy/improxy-prestable_man.cfg"
            }
            config_list = sdk2.parameters.Dict("List of extracted configs from gencfg", required=True,
                                               default=default_configs)

    def _run_new_generator(self, venv, generator_name, loggers, generators):
        loggers.append(sdk2.helpers.ProcessLog(self, logger=generator_name))
        generators.append(subprocess.Popen(["time",
                                            "bash",
                                            "./custom_generators/balancer_gencfg/gen-configs-{}.sh".format(
                                                generator_name),
                                            "api",
                                            self.Parameters.tag],
                                           stdout=loggers[-1].stdout, stderr=loggers[-1].stderr, env=venv))

    def on_execute(self):
        with self.memoize_stage.prepare_gencfg:
            sdk2.svn.Arcadia.checkout("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/gencfg", ".")

        with sandboxsdk.environments.VirtualEnvironment(do_not_remove=True) as venv:
            sandboxsdk.environments.PipEnvironment("sepelib", version="0.5.189a4", use_wheel=True, venv=venv).prepare()
            gencfg_env = os.environ.copy()
            gencfg_env["CUSTOM_PYTHON"] = venv.executable
            generators, loggers = list(), list()
            # improxy
            self._run_new_generator(gencfg_env, 'improxy', loggers, generators)
            # media-balancers
            self._run_new_generator(gencfg_env, 'media-balancers', loggers, generators)

            for idx, p in enumerate(generators):
                p.communicate()
                if p.returncode:
                    self.set_info(loggers[idx].stderr.path.open().read())
                    assert p.returncode == 0

        for config_type, path in self.Parameters.config_list.iteritems():
            generated_config_path = os.path.join(self.GENERATED_DIR, path)
            config_resource = sdk2.Resource[config_type]
            resource = sdk2.ResourceData(config_resource(self, self.Parameters.description, generated_config_path))
            if not os.path.exists(generated_config_path):
                raise Exception("Required config {} is not existed. Resource type: {}".format(
                    generated_config_path, config_type))
            resource.ready()
