# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.common.errors import TaskFailure

import sandbox.projects.common.nanny.nanny as nanny


class BalancerImagesThumbLoopConfig(sdk2.Resource):
    """
        Конфиг instancectl для балансера тумбов Я.Картинок
    """
    releasable = True


class BalancerImagesThumbIssNotifyHook(sdk2.Resource):
    """
        ISS notify hook для балансера тумбов Я.Картинок
    """
    releasable = True


class ImagesReleaseThumbBalancerLoopConf(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Релизим loop.conf для балансера тумбов Я.Картинок
    """

    LOOP_CONF_NAME = 'instancectl.conf'
    ISS_NOTIFY_CONF_NAME = 'iss_hook_notify'

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 180

        loop_content = sdk2.parameters.String("Loop configuration content", multiline=True, required=False)
        loop_svn_path = sdk2.parameters.ArcadiaUrl("SVN path to loop configuration file", required=False,
                                                   default='')

        iss_notify_bool = sdk2.parameters.Bool("Add notify hook", default=True)
        with iss_notify_bool.value[True]:
            iss_notify_content = sdk2.parameters.String("ISS notify hook content", multiline=True, required=False)
            iss_notify_svn_path = sdk2.parameters.ArcadiaUrl("SVN path to iss notify hook file", required=False,
                                                             default='')

    def on_enqueue(self):
        BalancerImagesThumbLoopConfig(self, "Loop.conf for thumbnail balancer", self.LOOP_CONF_NAME, ttl=48)
        if self.Parameters.iss_notify_bool:
            BalancerImagesThumbIssNotifyHook(self, "ISS notify hook for thumbnail balancer", self.ISS_NOTIFY_CONF_NAME,
                                             ttl=48)

    def get_resource(self, resource_content, resource_path, resource_type, resource_name):
        if len(resource_content) > 0:
            resource_file = resource_type.find(task_id=self.id).first()
            resource_file.path.write_bytes(
                resource_content
            )
        elif len(resource_path) > 0:
            sdk2.svn.Arcadia.export(resource_path, resource_name)
        else:
            raise TaskFailure("Empty set of parameters with content")

    def on_execute(self):
        # loop.conf
        self.get_resource(self.Parameters.loop_content,
                          self.Parameters.loop_svn_path,
                          BalancerImagesThumbLoopConfig,
                          self.LOOP_CONF_NAME)
        # iss_hook_notify
        if self.Parameters.iss_notify_bool:
            self.get_resource(self.Parameters.iss_notify_content,
                              self.Parameters.iss_notify_svn_path,
                              BalancerImagesThumbIssNotifyHook,
                              self.ISS_NOTIFY_CONF_NAME)
