import os

from sandbox.projects import resource_types
from sandbox.projects.balancer import resources as balancer_resource_types
from sandbox.projects.common.balancer_sepe.run_tests import MediaTestBalancer
from sandbox.sandboxsdk.channel import channel


class MediaTestRim(MediaTestBalancer):
    type = 'MEDIA_TEST_RIM'

    @staticmethod
    def _get_gencfg_dir():
        return "imgs-rim"

    def _get_config_dir(self):
        return self.abs_path("imgs-rim")

    def _get_config_resource_path(self, name):
        resource_map = {
            str(balancer_resource_types.BALANCER_RIM_SAS_CONFIG): "imgs_rim_sas.cfg",
            str(balancer_resource_types.BALANCER_RIM_MAN_CONFIG): "imgs_rim_man.cfg",
            str(balancer_resource_types.BALANCER_RIM_VLA_CONFIG): "imgs_rim_vla.cfg",
            str(balancer_resource_types.BALANCER_RIM_ACCEPTANCE_CONFIG): "imgs_rim_priemka.cfg"
        }
        return os.path.join(
            self._get_config_dir(),
            resource_map[name])

    @staticmethod
    def _get_config_names():
        return [
            balancer_resource_types.BALANCER_RIM_SAS_CONFIG,
            balancer_resource_types.BALANCER_RIM_MAN_CONFIG,
            balancer_resource_types.BALANCER_RIM_VLA_CONFIG,
            balancer_resource_types.BALANCER_RIM_ACCEPTANCE_CONFIG,
        ]

    def _get_balancer_opts(self, http_port):
        if 'certs_path' not in self.ctx:
            self._prepare_certs()
        opts = {
            'SkipBindToServiceAddrs': 'True',
            'InstancePort': http_port,
            'InstancePortSSL': http_port + 1,
            'SSLCert': os.path.join(
                self.ctx['certs_path'],
                resource_types.TEST_SSL_CERTS.public_certificate
            ),
            'SSLCertKey': os.path.join(
                self.ctx['certs_path'],
                resource_types.TEST_SSL_CERTS.private_certificate
            ),
        }
        return opts

    def _get_tests(self):
        return {
            'stat_ruchka': {
                'desr': 'Statistic output',
                'func': self.check_stat_ruchka,
            },
            'shutdown': {
                'desr': 'Graceful shutdown',
                'func': self.graceful_shutdown,
            },
            'version': {
                'desr': 'Version ruchka',
                'func': self.check_version_ruchka,
            },
        }

    def on_execute(self):
        MediaTestBalancer.on_execute(self)

        for resource_type in self._get_config_names():
            res = self.list_resources(resource_type=resource_type)[0]
            channel.sandbox.set_resource_attribute(res.id, "ttl", "inf")


__Task__ = MediaTestRim
