import os
import os.path
import shutil
import time

from sandbox.sandboxsdk import copy
from sandbox.sandboxsdk import errors
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import paths

from sandbox.projects.common.mediasearch import ban as media_ban
from sandbox.projects.images.bans import resources as images_bans_resources


class RemotePathParameter(parameters.SandboxStringParameter):
    name = 'remote_path'
    description = 'Remote path'


class ImagesReleaseAntivirusMasksBan(media_ban.ImagesBaseReleaseBanTask):
    """
        Builds antivirus ban for Yandex.Images service
    """

    type = "IMAGES_RELEASE_ANTIVIRUS_MASKS_BAN"

    client_tags = media_ban.ImagesBaseReleaseBanTask.client_tags
    cores = 1

    release_subject = "images/middle/antivirusmasks-data-{timestamp}"
    release_comment = "regular images ban file (antivirus)"
    push_signal_name = "antivirus_masks_ban"

    ban_resource = images_bans_resources.IMAGES_MIDDLESEARCH_MALWARE_MASKS_TRIE
    version_resource = images_bans_resources.IMAGES_MIDDLESEARCH_MALWARE_MASKS_VERSION
    release_resources = (ban_resource, version_resource)

    input_parameters = \
        (RemotePathParameter,) + \
        media_ban.ImagesBaseReleaseBanTask.create_input_parameters(run_tests=True, enable_semaphore=True)

    def _build_ban(self):
        version_path = self.abs_path(self.version_resource.basename)
        with open(version_path, "w") as version_file:
            version_file.write("{}".format(int(time.time())))
        self._register_ban(self.descr, version_path, self.version_resource)

        upload_path = self.abs_path("upload")
        paths.remove_path(upload_path)
        copy.RemoteCopy(self.ctx[RemotePathParameter.name], upload_path)()
        upload_items = os.listdir(upload_path)
        if len(upload_items) != 1:
            raise errors.SandboxTaskFailureError("Invalid items uploaded: {}".format(upload_items))

        trie_path = self.abs_path(self.ban_resource.basename)
        shutil.copyfile(os.path.join(upload_path, upload_items[0]), trie_path)
        self._register_ban(self.descr, trie_path, self.ban_resource)
        self._set_release_signal()

        return os.stat(trie_path).st_size

    def _test_ban(self, build_task_id):
        return [self._test_task(build_task_id, self.ban_resource)]


__Task__ = ImagesReleaseAntivirusMasksBan
