import os
import logging

from sandbox.sandboxsdk import process

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch import ban as media_ban
from sandbox.projects.images.bans import yt_task
from sandbox.projects.images.bans import resources as images_bans_resources


class ImagesReleaseChildpornoBan(yt_task.YtTask, media_ban.ImagesBaseReleaseBanTask):
    """
        Builds childporno ban resources for Yandex.Images service
    """

    type = "IMAGES_RELEASE_CHILDPORNO_BAN"
    client_tags = media_ban.ImagesBaseReleaseBanTask.client_tags & yt_task.YtTask.client_tags

    input_parameters = \
        media_ban.ImagesBaseReleaseBanTask.create_input_parameters(enable_semaphore=True) + \
        yt_task.YtTask.create_params("arnold.yt.yandex.net", "//home/antispam/export/images/CpPornoHosts")

    vault_owner = "IMAGES-BAN"

    ban_resource = images_bans_resources.IMAGES_MIDDLESEARCH_CHILDPORNO_HOSTS_BAN_FILE
    version_resource = images_bans_resources.IMAGES_MIDDLESEARCH_CHILDPORNO_BAN_VERSION

    release_subject = "images/middle/childporno-data-{timestamp}"
    release_comment = "daily images ban file (childporno)"
    release_resources = (ban_resource, version_resource)
    push_signal_name = "childporno_ban"

    def _build_ban(self):
        # check
        version_path = self.abs_path("childporno.version")
        with open(version_path, "w") as version_file:
            version_file.write(self._yt_check())

        if self._skip_build(version_path, self.version_resource):
            logging.info("Nothing to release")
            return 0

        self._register_ban(self.descr, version_path, self.version_resource)

        # build
        hosts_path = self.abs_path("childporno.hosts")
        with open(hosts_path, "w") as hosts_file:
            hosts = set()
            for host in self._yt_get(["host"]):
                _, host_no_scheme = host.split("://", 1)
                hosts.add(host_no_scheme)

            for host in hosts:
                hosts_file.write(host + "\n")

        self._register_ban(self.descr, hosts_path, resource_types.OTHER_RESOURCE)

        hasher_tool = self._tool(images_bans_resources.IMAGES_URL2FASTBAN_EXECUTABLE)

        hashes_path = self.abs_path(self.ban_resource.basename)
        process.run_process([
            hasher_tool,
            "--mode", "hashes",
            "--url-type", "host,image_host",
            "--ban-reason", "common",
            "--ban-type", "url",
            "--input", hosts_path,
            "--output", hashes_path,
        ], log_prefix="hasher")
        self._register_ban(self.descr, hashes_path, self.ban_resource)
        self._set_release_signal()

        return os.stat(hashes_path).st_size

    def _test_ban(self, build_task_id):
        return [self._test_task(build_task_id, self.ban_resource)]


__Task__ = ImagesReleaseChildpornoBan
