import os

from sandbox.sandboxsdk import process

from sandbox.projects.common.mediasearch import ban as media_ban
from sandbox.projects.images.bans import yt_task
from sandbox.projects.images.bans import resources as images_bans_resources


class ImagesReleaseCvBan(yt_task.YtTask, media_ban.ImagesBaseReleaseBanTask):
    """
        Builds cv ban resources for Yandex.Images service
    """

    type = "IMAGES_RELEASE_CV_BAN"
    client_tags = media_ban.ImagesBaseReleaseBanTask.client_tags & yt_task.YtTask.client_tags

    input_parameters = \
        media_ban.ImagesBaseReleaseBanTask.create_input_parameters(enable_semaphore=True) + \
        yt_task.YtTask.create_params("arnold.yt.yandex.net", "//home/cvtest/similar/face_bans")


    vault_owner = "IMAGES-BAN"

    ban_resource = images_bans_resources.IMAGES_MIDDLESEARCH_CV_BAN_FOLDER

    release_subject = "images/middle/cvban-data-{timestamp}"
    release_comment = "daily images ban data (cv bans)"
    release_resources = (ban_resource)
    push_signal_name = "cv_ban"

    def _build_ban(self):
        ban_tool = self._tool(images_bans_resources.IMAGES_CV_FACES_BAN_TOOL_EXECUTABLE)

        # build
        ban_path = self.abs_path("cv_faces")
        os.makedirs(ban_path)
        process.run_process([
            ban_tool,
            "--cluster", self._yt_proxy(),
            "--token", self.get_vault_data(self.vault_owner, "yt_token"),
            "--path", self._yt_table(),
            "--result", ban_path,
        ], log_prefix="ban_tool")

        self._register_ban(self.descr, ban_path, self.ban_resource)
        self._set_release_signal()
        max_file_size = max([os.stat(os.path.join(ban_path, f)).st_size for f in os.listdir(ban_path) if os.path.isfile(os.path.join(ban_path, f))])
        return max_file_size

    def _test_ban(self, build_task_id):
        return [self._test_task(build_task_id, self.ban_resource)]


__Task__ = ImagesReleaseCvBan
