import logging
import os

from sandbox.sandboxsdk import process

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch import ban as media_ban
from sandbox.projects.images.bans import yt_task
from sandbox.projects.images.bans import resources as images_bans_resources


class ImagesReleaseRimDocumentsBan(yt_task.YtTask, media_ban.ImagesBaseReleaseBanTask):
    """
        Builds ban resource for Related Images documents
    """

    type = "IMAGES_RELEASE_RIM_DOCUMENTS_BAN"
    client_tags = media_ban.ImagesBaseReleaseBanTask.client_tags & yt_task.YtTask.client_tags

    vault_owner = "IMAGES-BAN"

    input_parameters = \
        media_ban.ImagesBaseReleaseBanTask.create_input_parameters(enable_semaphore=True) + \
        yt_task.YtTask.create_params("banach.yt.yandex.net", "//home/images/relatedimages/ban.list")

    release_subject = "images/middle/rim-documents-{timestamp}"
    release_comment = "daily images RIM ban file (documents)"
    push_signal_name = "rim_documents_ban"

    ban_resource = images_bans_resources.IMAGES_RIM_BAN_QUERYSEARCH_TRIE
    version_resource = images_bans_resources.IMAGES_RIM_BAN_QUERYSEARCH_VERSION
    release_resources = (ban_resource, version_resource)

    def _build_ban(self):
        # check
        version_path = self.abs_path("rim.ban.version")
        with open(version_path, "w") as version_file:
            version_file.write(self._yt_check())

        if self._skip_build(version_path, self.version_resource):
            logging.info("Nothing to release")
            return 0

        self._register_ban(self.descr, version_path, self.version_resource)

        # build
        doc_keys_path = self.abs_path("doc.keys")
        with open(doc_keys_path, "w") as keys_file:
            for docid in self._yt_get(["docid"]):
                keys_file.write(docid + "\n")

        # querydata_indexer
        trie_path = self.abs_path(self.ban_resource.basename)
        indexer_tool = self._tool(images_bans_resources.IMAGES_QUERYDATAINDEXER_EXECUTABLE)

        process.run_process([
            indexer_tool,
            "--no-keywords",
            "--data-namespace", "rim",
            "--key-semantics", "none",
            "--local-input", doc_keys_path,
            "--output", trie_path], outputs_to_one_file=False, log_prefix="indexer")

        self._register_ban(self.descr, doc_keys_path, resource_types.OTHER_RESOURCE)
        self._register_ban(self.descr, trie_path, self.ban_resource)

        return os.stat(trie_path).st_size

    def _test_ban(self, build_task_id):
        return []


__Task__ = ImagesReleaseRimDocumentsBan
