from sandbox import sdk2
from sandbox.projects import resource_types


class BanResource(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.images_releasers + [
        'anoh', 'krivokon', 'fedorenko',
        'robot-images-money', 'robot-images-sandbox', 'robot-antispam',
        'panovav', 'gritsaev', 'foxxmary'
    ]


class ToolResource(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['anoh', 'fedorenko', 'foxxmary', 'woxalex']
    images_subscribers = ['images-releases']


class IMAGES_MIDDLESEARCH_ANTIPIRATE_URLS_BAN_FILE(BanResource):
    """
        Antipirate ban trie
    """
    basename = 'index-ban.trie'


class IMAGES_MIDDLESEARCH_ANTIPIRATE_URLS_BAN_VERSION(BanResource):
    """
        Antipirate ban version
    """
    basename = 'index-ban.version'


class IMAGES_MIDDLESEARCH_ANTIPIRATE_URLS_BAN_GRIMHOLD(BanResource):
    """
        Antipirate ban data from grimhold
    """
    basename = 'image.index.ban.querydata'


class IMAGES_MIDDLESEARCH_ROTTEN_URLS_BLOOM_FILTER(BanResource):
    """
        404 urls ban bloom filter
    """
    basename = 'rotten-urls.vec'


class IMAGES_MIDDLESEARCH_ROTTEN_URLS_BAN_VERSION(BanResource):
    """
        404 urls ban version
    """
    basename = 'rotten-urls.version'


class IMAGES_MIDDLESEARCH_ROTTEN_HOSTS_BAN_FILE(BanResource):
    """
        404 hosts ban trie
    """
    basename = 'rotten-hosts.vec'


class IMAGES_MIDDLESEARCH_ROTTEN_HOSTS_BAN_VERSION(BanResource):
    """
        404 hosts ban version
    """
    basename = 'rotten-hosts.version'


class IMAGES_MIDDLESEARCH_ANTISPAM_OWNERS_BAN_FILE(BanResource):
    """
        Antispam owners ban trie
    """
    basename = 'antispam-owners.vec'


class IMAGES_MIDDLESEARCH_ANTISPAM_BAN_VERSION(BanResource):
    """
        Antispam owners ban version
    """
    basename = 'antispam-owners.version'


class IMAGES_MIDDLESEARCH_ANTIPORNO_PORNO_BAN_FILE(BanResource):
    """
        Antiporno ban trie
    """
    ban_reason = 'porno'
    basename = 'antiporno-porno.vec'


class IMAGES_MIDDLESEARCH_ANTIPORNO_GRUESOME_BAN_FILE(BanResource):
    """
        Antiporno ban trie
    """
    ban_reason = 'gruesome'
    basename = 'antiporno-gruesome.vec'


class IMAGES_MIDDLESEARCH_ANTIPORNO_PERVERSION_BAN_FILE(BanResource):
    """
        Antiporno ban trie
    """
    ban_reason = 'perversion'
    basename = 'antiporno-perversion.vec'


class IMAGES_MIDDLESEARCH_ANTIPORNO_BAN_VERSION(BanResource):
    """
        Antiporno ban version
    """
    basename = 'antiporno.version'


class IMAGES_MIDDLESEARCH_MALWARE_MASKS_TRIE(BanResource):
    """
        trie with antispam malware information for images.
        SEARCHSPAM-10928
    """
    basename = 'antivirus-masks.trie'


class IMAGES_MIDDLESEARCH_MALWARE_MASKS_VERSION(BanResource):
    """
        Antispam malware ban version
    """
    basename = 'antivirus-masks.version'


class IMAGES_MIDDLESEARCH_CHILDPORNO_HOSTS_BAN_FILE(BanResource):
    """
        Childporno ban trie
    """
    basename = 'childporno-hosts.vec'


class IMAGES_MIDDLESEARCH_CHILDPORNO_BAN_VERSION(BanResource):
    """
        Childporno ban version
    """
    basename = 'childporno-hosts.version'


class IMAGES_MIDDLESEARCH_QUERY_URL_BAN_FILE(BanResource):
    """
        Toloka ban trie (main index)
    """
    index_prefix = "//home/images"
    basename = 'indexquban.trie'


class IMAGES_MIDDLESEARCH_QUERY_URL_QUICK_BAN_FILE(BanResource):
    """
        Toloka ban trie (quick index)
    """
    index_prefix = "//home/imgfast/images_fast"
    basename = 'indexquban-quick.trie'


class IMAGES_MIDDLESEARCH_QUERY_BAN_VERSION(BanResource):
    """
        Toloka ban version
    """
    basename = 'indexquban.version'


class IMAGES_MIDDLESEARCH_QUERY_QUICK_BAN_VERSION(BanResource):
    """
        Toloka ban version
    """
    basename = 'indexquban-quick.version'


class IMAGES_MIDDLESEARCH_COMMERCIAL_TRIE(BanResource):
    """
        Commercial data trie
    """
    basename = 'commercial_data.trie'


class IMAGES_MIDDLESEARCH_COMMERCIAL_TRIE_VERSION(BanResource):
    """
        Commercial data version
    """
    basename = 'commercial_data.version'


class IMAGES_MIDDLESEARCH_COMMERCIAL_QUERY_BAN_TRIE(BanResource):
    """
        Commercial ban trie
    """
    basename = 'commercial_query_ban.trie'


class IMAGES_MIDDLESEARCH_COMMERCIAL_QUERY_BAN_VERSION(BanResource):
    """
        Commercial ban version
    """
    basename = 'commercial_query_ban.version'


class THUMBS_BAN_GRIMHOLD_FILE(BanResource):
    """
        Thumb ban data from grimhold
    """
    basename = 'image.thumb.ban.querydata'


class THUMBS_BAN_QUERYSEARCH_TRIE(BanResource):
    """
        Thumb ban trie
    """
    basename = 'thumbs-ban.trie'


class THUMBS_BAN_QUERYSEARCH_VERSION(BanResource):
    """
        Thumb ban version
    """
    basename = 'thumbs-ban.version'


class IMAGES_GEOBASE5_SNAPSHOT(BanResource):
    """
        Geobase snapshot for Toloka ban generation
    """
    pass


class IMAGES_ROTTENHOSTS_EXECUTABLE(ToolResource):
    """
        Utility to generate 404 hosts ban
    """
    arcadia_build_path = 'extsearch/images/robot/index/ban/rottenhosts/rottenhosts'


class IMAGES_QUERYDATAINDEXER_EXECUTABLE(ToolResource):
    """
        Utility to generate Antipirate ban
    """
    arcadia_build_path = 'yweb/querydata/querydata_indexer/querydata_indexer'


class IMAGES_MRTOLOKA_EXECUTABLE(ToolResource):
    """
        Utility to generate Toloka ban
    """
    arcadia_build_path = 'extsearch/images/robot/index/mr_toloka/mr_toloka'


class IMAGES_COMMERCIAL_BAN_BUILDER_EXECUTABLE(ToolResource):
    """
        Utility to generate commercial ban files for Yandex.Images service
    """
    arcadia_build_path = 'extsearch/images/money/tools/commercial_ban/commercial_ban'


class IMAGES_GEOBASE3_SNAPSHOT(ToolResource):
    """
        Geobase snapshot for Yandex.Images releted tasks
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


class IMAGES_URL2FASTBAN_EXECUTABLE(ToolResource):
    """
        Utility to generate vectors
    """
    arcadia_build_path = 'extsearch/images/tools/url2fastban/url2fastban'


class IMAGES_BAN404_EXECUTABLE(ToolResource):
    """
        Utility to generate 404 urls ban
    """
    arcadia_build_path = 'extsearch/images/robot/tools/ban404/ban404'


class IMAGES_RIM_BAN_QUERYSEARCH_TRIE(BanResource):
    """
        Rim documents ban trie
    """
    releasers = BanResource.releasers + ['kigan']
    basename = 'rim-ban.trie'


class IMAGES_RIM_BAN_QUERYSEARCH_VERSION(BanResource):
    """
        Rim documents ban version
    """
    releasers = BanResource.releasers + ['kigan']
    basename = 'rim-ban.version'


class IMAGES_RIM_BAN_RELATEDDOCS_TRIE(BanResource):
    """
        Rim related documents ban trie
    """
    releasers = BanResource.releasers + ['kigan']
    basename = 'rim-relateddocs-ban.trie'


class IMAGES_RIM_BAN_RELATEDDOCS_VERSION(BanResource):
    """
        Rim related documents ban version
    """
    releasers = BanResource.releasers + ['kigan']
    basename = 'rim-relateddocs-ban.version'


class IMAGES_MIDDLESEARCH_CV_BAN_FOLDER(BanResource):
    """
        CV data for ban
    """
    releasers = BanResource.releasers + ['woxalex']
    pass


class IMAGES_CV_FACES_BAN_TOOL_EXECUTABLE(ToolResource):
    """
        Utility to generate CV faces ban
    """
    releasers = ToolResource.releasers + ['woxalex']
    arcadia_build_path = 'cv/cbir_search/face_ban/make_clusters/make_clusters'


class IMAGES_MIDDLESEARCH_ANTIPIRATE_INDEX_HOST_STAT(BanResource):
    """
        index host statistic to reduce ban
    """
    basename = 'index-host-stat.tsv'


class IMAGES_BAN_REDUCE_TOOL_EXECUTABLE(ToolResource):
    """
        Utility to reduce antipirate ban data
    """
    arcadia_build_path = 'extsearch/images/tools/ban_reduce'
