from sandbox.projects.images.basesearch import components as images_basesearch_components
from sandbox.projects.images.basesearch import task as images_basesearch_task
from sandbox.projects.images.basesearch import ImagesAnalyzeBasesearchPerformance as img_basesearch_performance

BASESEARCH1_PARAMS = \
    images_basesearch_components.create_quick_imgsearch_params(n=1)
BASESEARCH2_PARAMS = \
    images_basesearch_components.create_quick_imgsearch_params(n=2)


class ImagesAnalyzeRtyserverPerformance(img_basesearch_performance.ImagesAnalyzeBasesearchPerformance):
    """
        Analyze rtyserver basesearch performance
    """

    type = 'IMAGES_ANALYZE_RTYSERVER_PERFORMANCE'

    # Override param to use FusionSearch obj instead of BaseSearch.
    use_fusion = True

    basesearch_parameters = \
        BASESEARCH1_PARAMS.params + \
        BASESEARCH2_PARAMS.params

    input_parameters = \
        img_basesearch_performance.create_images_analyze_basesearch_performance_parameters(basesearch_parameters)

    execution_space = 50 * 1024
    required_ram = 50 * 1024

    def on_execute(self):
        self._substitute_basetask_params()
        return img_basesearch_performance.ImagesAnalyzeBasesearchPerformance.on_execute(self)

    def _substitute_basetask_params(self):
        img_basesearch_performance.BASESEARCH1_PARAMS = BASESEARCH1_PARAMS
        img_basesearch_performance.BASESEARCH2_PARAMS = BASESEARCH2_PARAMS
        images_basesearch_task.BASESEARCH_PARAMS = \
            images_basesearch_components.create_quick_imgsearch_params()


__Task__ = ImagesAnalyzeRtyserverPerformance
