# -*- coding: utf-8 -*-

import logging
import json
from sandbox.sandboxsdk.channel import channel
import sandbox.common.types.client as ctc

from sandbox.projects.common.base_search_quality import node_types
from sandbox.projects.common.base_search_quality import response_diff_task
from sandbox.projects.common.base_search_quality.tree import htmldiff
from sandbox.projects.common.base_search_quality.response_saver import DefaultResponseSaverParams
from sandbox.projects.images import responses as images_responses


class _Thumb(dict):
    """Helper method to generate set of thumb properties from tab-separated string"""

    def __init__(self, data):
        self.__data = data
        content = data.split("\t")
        if len(content) % 2:
            content.append("")
        for i in xrange(0, len(content), 2):
            self[content[i]] = content[i + 1]

    def __str__(self):
        return self.__data


class _GtaRelatedAttributeNode(node_types.GtaRelatedAttributeNode):
    def WriteDiff(self, diff_file, query_number, property_path, values1, values2, changed_props):
        try:
            property_name = property_path[-1]
            if property_name == '_ImagesDups':
                thumbs1 = [_Thumb(data) for data in values1[0].split("\n")]
                thumbs2 = [_Thumb(data) for data in values2[0].split("\n")]
                node_types.write_objects_diff(diff_file, query_number, property_path + ["thumb"],
                                              thumbs1, thumbs2, changed_props)
                return True
            if property_name == '_ImagesJson':
                dups1 = json.loads(values1[0])
                dups2 = json.loads(values2[0])
                node_types.write_objects_diff(diff_file, query_number, property_path + ["dups"],
                                              dups1, dups2, changed_props)
                return True
            else:
                return super(_GtaRelatedAttributeNode, self).WriteDiff(
                    diff_file, query_number, property_name,
                    values1, values1, changed_props
                )
        except Exception as e:
            logging.error("Failure during attribute parsing, rollback to simple comparison: {}".format(e))
            return super(_GtaRelatedAttributeNode, self).WriteDiff(
                diff_file, query_number, property_name,
                values1, values1, changed_props
            )


# Generators of BASESEARCH_HR_RESPONSES
_GENERATION_TASK_TYPES = (
    'GET_MMETA_RESPONSES',
    'IMAGES_GET_BASESEARCH_RESPONSES',
    'IMAGES_GET_METASEARCH_RESPONSES',
)


class ImagesCompareBasesearchResponses(response_diff_task.BaseCompareBasesearchResponses):

    type = 'IMAGES_COMPARE_BASESEARCH_RESPONSES'

    required_ram = 160 << 10
    client_tags = ctc.Tag.LINUX_PRECISE

    def _find_queries(self, responses_resource):
        logging.info("Retrieving responses getting task, id=%s", responses_resource.task_id)
        task = channel.sandbox.get_task(responses_resource.task_id)
        if task.type not in _GENERATION_TASK_TYPES:
            logging.info("task {}.{} not in allowed _GENERATION_TASK_TYPES".format(responses_resource.task_id, task.type))
            return None
        return task.ctx[DefaultResponseSaverParams.QueriesParameter.name]

    def _get_custom_node_types(self):
        node_types = response_diff_task.BaseCompareBasesearchResponses._get_custom_node_types(self)
        node_types.update(htmldiff.node_types_dict([_GtaRelatedAttributeNode()]))
        return node_types

    def _get_response_patchers(self):
        patchers = response_diff_task.BaseCompareBasesearchResponses._get_response_patchers(self)
        patchers.extend(images_responses.get_response_patchers())
        return patchers


__Task__ = ImagesCompareBasesearchResponses
