from sandbox.projects.images import responses as images_responses
from sandbox.projects.images.basesearch import task as images_task


_OUT_RESOURCE_KEY = 'out_resource_id'
_STATS_KEY = 'stats'


class ImagesGetBasesearchResponses(images_responses.ResponsesTask,
                                   images_task.BaseImgsearchTask):

    type = 'IMAGES_GET_BASESEARCH_RESPONSES'
    required_ram = 144 << 10
    input_parameters = \
        images_task.BaseImgsearchTask.basesearch_input_parameters + \
        images_responses.ResponsesTask.input_parameters

    def on_enqueue(self):
        images_task.BaseImgsearchTask.on_enqueue(self)
        self._create_responses_resource(_OUT_RESOURCE_KEY)

    def on_execute(self):
        images_task.BaseImgsearchTask.on_execute(self)
        basesearch = self._get_imgsearch()
        with basesearch:
            self._get_responses(basesearch, _OUT_RESOURCE_KEY, _STATS_KEY)


__Task__ = ImagesGetBasesearchResponses
