import urllib2
import logging
import time

from sandbox.sandboxsdk import parameters

from sandbox.common.rest import Client as SandboxClient
from sandbox.projects import resource_types
from sandbox.projects.common import network
from sandbox.projects.common import profiling as search_profiling
from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.images.basesearch import task as images_task
from sandbox.projects.images import util
from sandbox.sandboxsdk.channel import channel


class ImagesRunStandaloneBasesearch(search_profiling.ProfilingTask,
                                    images_task.BaseImgsearchTask):
    """
        Benchmark for imgsearch
    """

    type = 'IMAGES_RUN_STANDALONE_BASESEARCH'
    GUARANTEED_RAM = 1024

    input_parameters = \
        images_task.BaseImgsearchTask.basesearch_input_parameters + \
        search_profiling.ProfilingTask.input_parameters

    def on_enqueue(self):
        images_task.BaseImgsearchTask.on_enqueue(self)
        self.execution_space = search_settings.ImagesSettings.basesearch_executable_disk(self.ctx, images_task.BASESEARCH_PARAMS.Database)
        calculated_ram = search_settings.ImagesSettings.basesearch_executable_memory(
            self.ctx,
            images_task.BASESEARCH_PARAMS.Database
        ) + 5 * 1024
        self.required_ram = max(calculated_ram, self.GUARANTEED_RAM)
        self.ctx['finish_request'] = False

    def on_execute(self):
        self.ctx['network_address'] = network.get_my_ipv6()
        channel.sandbox.set_task_context_value(self.id, 'network_address', self.ctx['network_address'])
        images_task.BaseImgsearchTask.on_execute(self)
        basesearch = self._get_imgsearch()

        self._profiling_init(basesearch, self.__get_perf_data_path())
        client = SandboxClient()
        with basesearch:
            # Wait for port ready
            util.wait_for_port_open("localhost", 17171, 7200)
            self.ctx['basesearch_ready'] = True
            channel.sandbox.set_task_context_value(self.id, 'basesearch_ready', self.ctx['basesearch_ready'])

            # Wait quit signal in context
            while True:
                if self.ctx['finish_request'] is True:
                    break
                if self.parent_id:
                    if client.task[self.parent_id].read()['status'] != "EXECUTING":
                        logging.info("Parent task finished")
                        break
                time.sleep(6)

            # Dump tass statistics for further analysis (experimental)
            try:
                tass_data = urllib2.urlopen("http://localhost:{}/tass".format(basesearch.port)).read()
                with open("tass.txt", "w") as f:
                    f.write(tass_data)
                self.create_resource(self.descr + ", tass", "tass.txt", resource_types.OTHER_RESOURCE)
            except Exception as e:
                logging.info("Failed to read tass stats: {}".format(e))

        self._profiling_report(basesearch, self.__get_perf_data_path())

    def _get_queries_parameter(self):
        return None

    def __get_perf_data_path(self, recreate=False):
        return self.abs_path("perf.data")


__Task__ = ImagesRunStandaloneBasesearch
