from sandbox.projects.common.search import functional_helpers as fh
from sandbox.projects.common.search import requester as search_requester
from sandbox.projects.images import responses as images_responses
from sandbox.projects.images.basesearch import task as images_task


class ImagesTestBasesearchFunctional(images_responses.ResponsesTask,
                                     images_task.BaseImgsearchTask):
    """
        Test non-search queries to basesearch

        Also shoot basesearch with search queries after main test to ensure that there are no deadlocks
    """

    type = 'IMAGES_TEST_BASESEARCH_FUNCTIONAL'

    input_parameters = (
        fh.QueriesParameter,
        fh.QueriesLimitParameter,
        search_requester.Params.WorkersCount,
        search_requester.Params.RequestTimeout
    ) + images_task.BaseImgsearchTask.basesearch_input_parameters

    def on_execute(self):
        images_task.BaseImgsearchTask.on_execute(self)
        fh.run_component_requesters(self, self._get_imgsearch(), fh.INFO_REQUESTS_BASE[fh.IMAGES])

    def _get_queries_parameter(self):
        return fh.QueriesParameter


__Task__ = ImagesTestBasesearchFunctional
