from sandbox.projects.common.base_search_quality import cgi_params
from sandbox.projects.images.basesearch import task as images_task


class ImagesTestBasesearchGtaParams(images_task.BaseImgsearchTask):
    """
        Test basesearch for reliability by querying with all possible gta attributes
    """

    type = 'IMAGES_TEST_BASESEARCH_GTA_PARAMS'

    input_parameters = \
        images_task.BaseImgsearchTask.basesearch_input_parameters + \
        cgi_params.PARAMS

    @property
    def footer(self):
        return '<strong>RPS: <span style="color: #007f00;">{}</span></strong>.'.format(
            self.ctx.get('rps')) if self.is_finished() else ''

    def on_execute(self):
        images_task.BaseImgsearchTask.on_execute(self)

        def _test_gta():
            self.ctx['rps'] = cgi_params.test_gta_params(self.ctx, basesearch)

        basesearch = self._get_imgsearch()
        with basesearch:
            basesearch.use_component(_test_gta)

    def _get_queries_parameter(self):
        return cgi_params.QueriesParameter


__Task__ = ImagesTestBasesearchGtaParams
