from sandbox.projects.common.base_search_quality import info_requests
from sandbox.projects.images.basesearch import task as images_task


_UNSUPPORTED_REQUESTS = ("fm", "herfinfo", "docattr", "snippets", "snippethits")
# NOTE: "docattr" is incompatible with current info requests because responces don't contain generated categs
# TODO: snippets, snippethits are incompatible with new snippetizer (produce empty responces)


class ImagesTestBasesearchInfoRequests(images_task.BaseImgsearchTask):
    """
        Test basesearch work with various info-requests
    """

    type = 'IMAGES_TEST_BASESEARCH_INFO_REQUESTS'

    input_parameters = \
        images_task.BaseImgsearchTask.basesearch_input_parameters + \
        info_requests.PARAMS

    def on_execute(self):
        images_task.BaseImgsearchTask.on_execute(self)
        basesearch = self._get_imgsearch()
        info_requests.test_info_requests(basesearch, ignore_errors_for_types=_UNSUPPORTED_REQUESTS)

    def _get_queries_parameter(self):
        return info_requests.QueriesParameter


__Task__ = ImagesTestBasesearchInfoRequests
