import logging

from sandbox.projects.common import massif
from sandbox.projects.common.search import components as search_components
from sandbox.projects.images.basesearch import ImagesTestBasesearchPerformance as performance_task
from sandbox import sandboxsdk


class SkipLockedFiles(sandboxsdk.parameters.SandboxStringParameter):
    name = 'skip_locked_files'
    description = 'Skip files'
    default_value= 'indexgeompacked;indexmeta;indexporn;indexface_v4nnindex;indexface_v4nnkey2pos;indexface_v4nnattr;indexface_v4nnattrpos;indexface_v4nnkeys;indexface_v5nnindex;indexface_v5nnkey2pos;indexface_v5nnattr;indexface_v5nnattrpos;indexface_v5nnkeys;detectedobjectsv3nnattr;detectedobjectsv3nnattrpos;detectedobjectsv3nnconverter;detectedobjectsv3nnheader;detectedobjectsv3nnindex;detectedobjectsv3nnkey2pos;detectedobjectsv3nnkeys;detectedobjectsv3nnvocab;indexv10tlknnheader;indexv10tlknnindex;indexv10tlknnkey2pos;indexv10tlknnattrpos;indexv10tlknnkeys;indexv10tlknnvocab;indexv10tlknnattr;indexv10tlknnconverter;indexv10marketnnheader;indexv10marketnnindex;indexv10marketnnkey2pos;indexv10marketnnattrpos;indexv10marketnnkeys;indexv10marketnnvocab;indexv10marketnnattr;indexv10marketnnconverter;detectedobjectsv4nnattr;detectedobjectsv4nnattrpos;detectedobjectsv4nnconverter;detectedobjectsv4nnheader;detectedobjectsv4nnindex;detectedobjectsv4nnkey2pos;detectedobjectsv4nnkeys;detectedobjectsv4nnvocab;docindex_l1.megawad;indexerf.wad;indexregerf.wad;docindex_cbir.megawad;'
    required = True


class ImagesTestBasesearchPerformanceWithMemLock(performance_task.ImagesTestBasesearchPerformance):
    type = None

    input_parameters = \
        (SkipLockedFiles,) + \
        performance_task.ImagesTestBasesearchPerformance.input_parameters


    def init_search_component(self, basesearch):
        performance_task.ImagesTestBasesearchPerformance.init_search_component(self, basesearch)
        lockedFilesStr = basesearch.config.get_parameter("Collection/LockIndexFiles")
        if lockedFilesStr is None:
            return
        s = lockedFilesStr.find("'")
        e = lockedFilesStr.rfind("'")
        if s != e and s != -1:
            lockedFiles = set(lockedFilesStr[s+1:e].split(";"))
            skipLockedFiles = set(self.ctx[SkipLockedFiles.name].split(";"))
            if len(lockedFiles.intersection(skipLockedFiles)) > 0:
                logging.info("Remove locked files: %s" % str(lockedFiles.intersection(skipLockedFiles)))
                lockedFiles = lockedFiles.difference(skipLockedFiles)
                basesearch.replace_config_parameter("Collection/LockIndexFiles", lockedFilesStr[:s+1] + ';'.join(lockedFiles) + lockedFilesStr[e:])


_BASE_CLASS = massif.generate_task(
    search_components.DefaultBasesearchParams,
    ImagesTestBasesearchPerformanceWithMemLock,
    start_timeout=search_components.DEFAULT_START_TIMEOUT * 4,
    tune_archive_settings=True
)


class ImagesTestBasesearchMassif(_BASE_CLASS):
    type = 'IMAGES_TEST_BASESEARCH_MASSIF'

    def init_search_component(self, component):
        component.replace_config_parameter("Collection/UseIndexMapping", 'False')
        _BASE_CLASS.init_search_component(self, component)
    

    def initCtx(self):
        self.ctx['kill_timeout'] = 6 * 60 * 60  # 6 hours


__Task__ = ImagesTestBasesearchMassif
