import urllib2
import logging

from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types
from sandbox.projects.common import dolbilka
from sandbox.projects.common import profiling as search_profiling
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.images.basesearch import task as images_task


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    group = dolbilka.DOLBILKA_GROUP
    resource_type = resource_types.BASESEARCH_PLAN
    required = True


class ImagesTestBasesearchPerformance(search_performance.OldShootingTask,
                                      search_profiling.ProfilingTask,
                                      images_task.BaseImgsearchTask):
    """
        Benchmark for imgsearch
    """

    type = 'IMAGES_TEST_BASESEARCH_PERFORMANCE'
    GUARANTEED_RAM = 1024

    input_parameters = \
        (PlanParameter,) + \
        images_task.BaseImgsearchTask.basesearch_input_parameters + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        search_profiling.ProfilingTask.input_parameters

    def on_enqueue(self):
        images_task.BaseImgsearchTask.on_enqueue(self)
        self.execution_space = search_settings.ImagesSettings.basesearch_executable_disk(self.ctx, images_task.BASESEARCH_PARAMS.Database)
        calculated_ram = search_settings.ImagesSettings.basesearch_executable_memory(
            self.ctx,
            images_task.BASESEARCH_PARAMS.Database
        ) + 5 * 1024
        self.required_ram = max(calculated_ram, self.GUARANTEED_RAM)

    def on_execute(self):
        images_task.BaseImgsearchTask.on_execute(self)

        basesearch = self._get_imgsearch()

        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        self._profiling_init(basesearch, self.__get_perf_data_path())
        with basesearch:
            self._old_shoot(basesearch, self.ctx[PlanParameter.name])
            # Dump tass statistics for further analysis (experimental)
            try:
                tass_data = urllib2.urlopen("http://localhost:{}/tass".format(basesearch.port)).read()
                with open("tass.txt", "w") as f:
                    f.write(tass_data)
                self.create_resource(self.descr + ", tass", "tass.txt", resource_types.OTHER_RESOURCE)
            except Exception as e:
                logging.info("Failed to read tass stats: {}".format(e))

        self._profiling_report(basesearch, self.__get_perf_data_path())

    def _get_queries_parameter(self):
        return PlanParameter

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        if "max_rps" in self.ctx:
            return "{:0.2f}".format(self.ctx["max_rps"])

    def __get_perf_data_path(self, recreate=False):
        return self.abs_path("perf.data")


__Task__ = ImagesTestBasesearchPerformance
