from sandbox.projects.common import sanitizer
from sandbox.projects.common.search import components as search_components
from sandbox.projects.images.basesearch import ImagesTestBasesearchPerformance as performance_task


_BASE_CLASS = sanitizer.generate_task(
    search_components.DefaultBasesearchParams,
    performance_task.ImagesTestBasesearchPerformance,
    start_timeout=search_components.DEFAULT_START_TIMEOUT * 4
)


class ImagesTestBasesearchSanitizer(_BASE_CLASS):
    type = 'IMAGES_TEST_BASESEARCH_SANITIZER'


__Task__ = ImagesTestBasesearchSanitizer
