from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import sandboxapi

from sandbox.projects import resource_types
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.common.search import yasm as search_yasm
from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.images.basesearch import task as images_task


_INSTANCE_TYPE = "base"
# _INSTANCE_TAG = "prod_imgs-base_msk_yandsearch"
_INSTANCE_TAG = (
    ("ctype", "prod"),
    ("geo", "msk"),
    ("prj", "imgs-base"),
    ("tier", "yandsearch"),
)


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = resource_types.BASESEARCH_PLAN
    required = True


class ImagesTestBasesearchUnistat(search_performance.OldShootingTask,
                                  search_yasm.YasmAgentTask,
                                  images_task.BaseImgsearchTask):
    """
        Verify unistat implementation in basesearch
    """

    type = 'IMAGES_TEST_BASESEARCH_UNISTAT'

    input_parameters = \
        images_task.BaseImgsearchTask.basesearch_input_parameters + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        search_yasm.YasmAgentTask.input_parameters + \
        (PlanParameter,)

    def on_enqueue(self):
        images_task.BaseImgsearchTask.on_enqueue(self)
        self.create_resource(
            self.descr,
            self.__unistat_signals(),
            resource_types.BASESEARCH_UNISTAT_SIGNALS,
            arch=sandboxapi.ARCH_ANY
        )
        self.execution_space = search_settings.ImagesSettings.basesearch_executable_disk(self.ctx, images_task.BASESEARCH_PARAMS.Database)
        self.required_ram = search_settings.ImagesSettings.basesearch_executable_memory(
            self.ctx,
            images_task.BASESEARCH_PARAMS.Database
        ) + 5 * 1024

    def on_execute(self):
        images_task.BaseImgsearchTask.on_execute(self)

        basesearch = self._get_imgsearch()
        yasmagent = self._yasmagent(basesearch, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        yasmlistener = self._yasmlistener(yasmagent, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)

        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        with basesearch, yasmagent, yasmlistener:
            self._old_shoot(basesearch, self.ctx[PlanParameter.name])
        yasmlistener.dump(self.__unistat_signals())

    def _get_queries_parameter(self):
        return PlanParameter

    def __unistat_signals(self):
        return self.abs_path("unistat-signals.txt")


__Task__ = ImagesTestBasesearchUnistat
