from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops


class BasesearchResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops()


class IMGSEARCH_EXECUTABLE(BasesearchResource):
    """
        Executable (production)
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/base/imgsearch/imgsearch2'


class IMGSEARCH_EXECUTABLE_STAGING(IMGSEARCH_EXECUTABLE):
    """
        Executable (staging)
    """
    pass


class IMAGES_SEARCH_CONFIG(BasesearchResource):
    """
        Main search (production)
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgTier0.cfg'


class IMAGES_SEARCH_TIER1_CONFIG(BasesearchResource):
    """
        Tier1 search (production)
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgTier1.cfg'


class IMAGES_SEARCH_CONFIG_STAGING(IMAGES_SEARCH_CONFIG):
    """
        Main search (staging)
    """
    pass


class IMAGES_QUICK_SEARCH_CONFIG(BasesearchResource):
    """
        Quick search (production)
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgQuickTier0.cfg'


class IMAGES_QUICK_SEARCH_CONFIG_STAGING(IMAGES_QUICK_SEARCH_CONFIG):
    """
        Quick search (staging)
    """
    pass


class IMAGES_CBIR_SEARCH_CONFIG(BasesearchResource):
    """
        Main cbir
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgCBIRTier0.cfg'


class IMAGES_CBIR_SEARCH_TIER1_CONFIG(BasesearchResource):
    """
        Tier1 cbir
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgCBIRTier1.cfg'


class IMAGES_CBIR_QUICK_SEARCH_CONFIG(BasesearchResource):
    """
        Quick cbir
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgCBIRQuickTier0.cfg'


class IMAGES_ULTRA_SEARCH_CONFIG(BasesearchResource):
    """
        Main cbir
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/ImgUltraTier0.cfg'


class IMGQUICK_SAAS_RTYSERVER_CONFIGS_BUNDLE(BasesearchResource):
    """
        Quick rtyserver config bundle
    """
    pass


class IMGULTRA_SAAS_RTYSERVER_CONFIGS_BUNDLE(BasesearchResource):
    """
        Ultra rtyserver config bundle
    """
    pass
