from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.common.search.basesearch import task as search_task
import sandbox.projects.images.sysinfo as images_sysinfo
import sandbox.projects.images.basesearch.components as images_basesearch_components


BASESEARCH_PARAMS = images_basesearch_components.create_imgsearch_params()


class BaseImgsearchTask(images_sysinfo.SysinfoTask, search_task.BasesearchComponentTask):

    required_ram = 96 * 1024
    execution_space = 180 * 1024

    basesearch_input_parameters = \
        BASESEARCH_PARAMS.params + \
        search_task.BasesearchComponentTask.basesearch_input_parameters

    def on_execute(self):
        self._dump_sysinfo()
        search_task.BasesearchComponentTask.on_execute(self)

    def on_enqueue(self):
        search_task.BasesearchComponentTask.on_enqueue(self)
        search_settings.ImagesSettings.ensure_search_database(
            self,
            self._get_queries_parameter(),
            BASESEARCH_PARAMS.Database
        )

    def _get_imgsearch(self, params=BASESEARCH_PARAMS, use_fusion=False, **kwargs):
        if use_fusion:
            result = images_basesearch_components.get_quick_imgsearch(params=params, **kwargs)
        else:
            result = self._basesearch(params, **kwargs)

        # IMGDEVOPS-361
        basesearch_env = result.get_environment()
        basesearch_env.update({"MKL_CBWR": "COMPATIBLE"})
        result.set_environment(basesearch_env)

        return result

    def _component(self, params, *args, **kwargs):
        return images_basesearch_components.get_imgsearch(params=params, *args, **kwargs)

    def _get_queries_parameter(self):
        raise NotImplementedError()
