from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.images.models import resources as models_resources


class SearchTaskCommonParameters:
    """
        Parameters for search tasks
    """

    class Parameters(sdk2.Task.Parameters):
        # Config from gencfg
        config = sdk2.parameters.Resource('Generated configs by gencfg',
                                          resource_type=resource_types.CONFIG_GENERATOR_CONFIGS,
                                          required=False)

        # Shard identificators for auto search
        index_state = sdk2.parameters.String('Index state', required=False)
        partition_number = sdk2.parameters.Integer('Partition number', default=0, required=False)

        # Matrixnet parameters
        search_l1_models_archive = sdk2.parameters.Resource('Search L1 models archive (used on int L1 & embedding storage)',
                                                            resource_type=models_resources.IMAGES_L1_DYNAMIC_MODELS_ARCHIVE,
                                                            required=False)
