from sandbox.sandboxsdk import errors
from sandbox.projects.common.differ import printers


def decode_response(response):
    result = response
    if "answers" not in result:
        return {}
    for a in result["answers"]:
        if "type" in a and a["type"] == "images_rim_response":
            result = a
            break
    return result


def _wrap_block(key, output):
    new_output = []
    if output:
        new_output.append(printers.HtmlBlock.start(key))
        new_output.extend(output)
        new_output.append(printers.HtmlBlock.end())
    return new_output


def compare_json(object1, object2):

    def _print_block(key, value, color):
        if isinstance(value, dict):
            # subobject
            output = []
            output.append(printers.HtmlBlock.start(key, color))
            for k, v in value.iteritems():
                output.extend(_print_block(k, v, color))
            output.append(printers.HtmlBlock.end())
            return output
        elif isinstance(value, list):
            # sublist
            output = []
            output.append(printers.HtmlBlock.start(key, color))
            for i, v in enumerate(value):
                output.extend(_print_block("#{}".format(i), v, color))
            output.append(printers.HtmlBlock.end())
            return output
        elif isinstance(value, basestring):
            # simple key
            return [
                printers.HtmlBlock.start(key, color),
                printers.HtmlBlock.simple_data(value, text_bg_class=color),
                printers.HtmlBlock.end(),
            ]
        else:
            return []

    if object1 is None and object2 is not None:
        _print_block("", object2, printers.DiffType.ADDED)
        return []
    elif object1 is not None and object2 is None:
        _print_block("", object1, printers.DiffType.REMOVED)
        return []
    elif object1 is None and object2 is None:
        return []
    elif isinstance(object1, dict) and isinstance(object2, dict):
        # compare keys
        keys1, keys2 = set(object1.keys()), set(object2.keys())
        output = []
        for key in keys2.difference(keys1):
            output.extend(_print_block(key, object2[key], printers.DiffType.ADDED))
        for key in keys1.difference(keys2):
            output.extend(_print_block(key, object1[key], printers.DiffType.REMOVED))
        for key in keys1.intersection(keys2):
            output.extend(_wrap_block(key, compare_json(object1[key], object2[key])))
        return output
    elif isinstance(object1, list) and isinstance(object2, list):
        if len(object1) != len(object2):
            raise errors.SandboxTaskFailureError("Wrong lists: {} {}".format(object1, object2))
        i = 0
        output = []
        for o1, o2 in zip(sorted(object1), sorted(object2)):
            output.extend(_wrap_block("#{}".format(i), compare_json(o1, o2)))
            i += 1
        return output
    elif isinstance(object1, basestring) and isinstance(object2, basestring):
        # compare values
        if object1 != object2:
            line1, line2 = printers.match_string_color_changed(object1, object2)
            return [
                printers.HtmlBlock.colored_data(line1),
                printers.HtmlBlock.colored_data(line2),
            ]
        return []
    elif isinstance(object1, float) and isinstance(object2, float):
        if abs(object1 - object2) > 2e-4:
            line1, line2 = printers.match_string_color_changed(str(object1), str(object2))
            return [
                printers.HtmlBlock.colored_data(line1),
                printers.HtmlBlock.colored_data(line2),
            ]
        return []
    elif isinstance(object1, int) and isinstance(object2, int):
        # compare values
        if object1 != object2:
            line1, line2 = printers.match_string_color_changed(str(object1), str(object2))
            return [
                printers.HtmlBlock.colored_data(line1),
                printers.HtmlBlock.colored_data(line2),
            ]
        return []
    else:
        raise errors.SandboxTaskFailureError("Wrong objects to compare: {}, {}".format(object1, object2))


def compare(response1, response2, title):
    decoded_response1 = decode_response(response1)
    decoded_response2 = decode_response(response2)
    return _wrap_block(title, compare_json(decoded_response1, decoded_response2))
