import os.path
import tarfile

from sandbox import sdk2
import sandbox.common.types.resource as ctr

from sandbox.projects.common import string
from sandbox.projects.images.bans import resources as ban_resources
from sandbox.projects.images.daemons import resources as daemons_resources


_DATA_TYPE = "sync"


class ImagesGenerateRimpatchdaemonBanArchive(sdk2.Task):
    """
        Archives ban files to one file
    """

    class Parameters(sdk2.Task.Parameters):
        antipirate_ban = sdk2.parameters.LastReleasedResource(
            'Antipirate ban',
            resource_type=ban_resources.IMAGES_MIDDLESEARCH_ANTIPIRATE_URLS_BAN_FILE,
            state=(ctr.State.READY),
            required=True
        )
        antispam_ban = sdk2.parameters.LastReleasedResource(
            'Antispam ban',
            resource_type=ban_resources.IMAGES_MIDDLESEARCH_ANTISPAM_OWNERS_BAN_FILE,
            state=(ctr.State.READY),
            required=True
        )
        antivirus_ban = sdk2.parameters.LastReleasedResource(
            'Antivirus ban',
            resource_type=ban_resources.IMAGES_MIDDLESEARCH_MALWARE_MASKS_TRIE,
            state=(ctr.State.READY),
            required=True
        )
        childporno_ban = sdk2.parameters.LastReleasedResource(
            'Child porno ban',
            resource_type=ban_resources.IMAGES_MIDDLESEARCH_CHILDPORNO_HOSTS_BAN_FILE,
            state=(ctr.State.READY),
            required=True
        )
        relateddocs_ban = sdk2.parameters.LastReleasedResource(
            'Related images ban',
            resource_type=ban_resources.IMAGES_RIM_BAN_RELATEDDOCS_TRIE,
            state=(ctr.State.READY),
            required=True
        )
        attributes = sdk2.parameters.String(
            'Set additional attrs to resources (ex.: attr1=v1, attr2=v2)',
            do_not_copy=True
        )

    def on_execute(self):
        attributes = string.parse_attrs(self.Parameters.attributes)
        request_attributes = {k.format(_DATA_TYPE): v for k, v in attributes.iteritems()}

        archive_res = daemons_resources.IMAGES_RIMPATCH_DAEMON_BAN_ARCHIVE(
            self,
            self.Parameters.description,
            'ban_files.tar.gz'
        )
        for k in request_attributes:
            setattr(archive_res, k, request_attributes[k])

        archive_file = str(sdk2.ResourceData(archive_res).path)

        with tarfile.open(archive_file, "w|gz") as tar:
            antipirate_ban_path = str(sdk2.ResourceData(self.Parameters.antipirate_ban).path)
            tar.add(antipirate_ban_path, os.path.basename(antipirate_ban_path))
            antispam_ban_path = str(sdk2.ResourceData(self.Parameters.antispam_ban).path)
            tar.add(antispam_ban_path, os.path.basename(antispam_ban_path))
            antivirus_ban_path = str(sdk2.ResourceData(self.Parameters.antivirus_ban).path)
            tar.add(antivirus_ban_path, os.path.basename(antivirus_ban_path))
            childporno_ban_path = str(sdk2.ResourceData(self.Parameters.childporno_ban).path)
            tar.add(childporno_ban_path, os.path.basename(childporno_ban_path))
            relateddocs_ban_path = str(sdk2.ResourceData(self.Parameters.relateddocs_ban).path)
            tar.add(relateddocs_ban_path, os.path.basename(relateddocs_ban_path))
