import sandbox.common.types.client as ctc

from sandbox.projects.images.daemons import task as daemons_task


class ImagesGetNaildaemonResponses(daemons_task.BaseGetResponsesTask, daemons_task.BaseNaildaemonTask):
    """
        Get naildaemon responses
    """

    type = 'IMAGES_GET_NAILDAEMON_RESPONSES'

    client_tags = ctc.Tag.INTEL_E5_2650

    input_parameters = \
        daemons_task.BaseGetResponsesTask.input_parameters + \
        daemons_task.BaseNaildaemonTask.input_parameters

    def on_enqueue(self):
        daemons_task.BaseGetResponsesTask.on_enqueue(self)
        daemons_task.BaseNaildaemonTask.on_enqueue(self)

    def _get_daemon(self):
        return daemons_task.BaseNaildaemonTask._get_daemon(self)

    def _get_queries_parameter(self):
        return daemons_task.QueriesParameter


__Task__ = ImagesGetNaildaemonResponses
