from sandbox.projects.images.daemons import task as daemons_task
from sandbox.sandboxsdk.channel import channel


class ImagesGetRimdaemonResponses(daemons_task.BaseGetResponsesTask, daemons_task.BaseRimdaemonTask):
    """
        Get rimdaemon responses from local instance
    """

    type = 'IMAGES_GET_RIMDAEMON_RESPONSES'

    allowed_response_http_codes = [200, 404]

    input_parameters = \
        daemons_task.BaseGetResponsesTask.input_parameters + \
        daemons_task.BaseRimdaemonTask.input_parameters

    def on_enqueue(self):
        daemons_task.BaseGetResponsesTask.on_enqueue(self)
        daemons_task.BaseRimdaemonTask.on_enqueue(self)

    def _get_attributes(self):
        queries = channel.sandbox.get_resource(self.ctx[daemons_task.QueriesParameter.name])
        return queries.attributes

    def _get_daemon(self):
        return daemons_task.BaseRimdaemonTask._get_daemon(self)

    def _get_queries_parameter(self):
        return daemons_task.QueriesParameter


__Task__ = ImagesGetRimdaemonResponses
