from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types
from sandbox.projects.common import profiling
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.images.daemons import task as daemons_task
from sandbox.projects.tank.load_resources import resources as tank_resources


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = resource_types.BASESEARCH_PLAN
    required = True


class ImagesTestCbirdaemon2Performance(search_performance.OldShootingTask,
                                       profiling.ProfilingTask,
                                       daemons_task.BaseCbirdaemonTask):
    """
        Benchmark for cbirdaemon2
    """

    type = 'IMAGES_TEST_CBIRDAEMON2_PERFORMANCE'

    input_parameters = \
        (PlanParameter,) + \
        daemons_task.BaseCbirdaemonTask.input_parameters + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        profiling.ProfilingTask.input_parameters

    def on_execute(self):
        cbirdaemon = self._get_daemon()
        self.init_search_component(cbirdaemon)

        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        self._profiling_init(cbirdaemon, self.__get_perf_data_path())
        with cbirdaemon:
            self._old_shoot(cbirdaemon, self.ctx[PlanParameter.name])
        self._profiling_report(cbirdaemon, self.__get_perf_data_path())

    # standard hook for massiff and sanitizer task generators
    def init_search_component(self, component):
        pass

    def _get_queries_parameter(self):
        return PlanParameter

    def __get_perf_data_path(self, recreate=False):
        return self.abs_path("perf.data")


__Task__ = ImagesTestCbirdaemon2Performance
