from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import sandboxapi

from sandbox.projects import resource_types
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.common.search import yasm as search_yasm
from sandbox.projects.images.daemons import task as daemons_task
from sandbox.projects.tank.load_resources import resources as tank_resources

_INSTANCE_TYPE = "cbrd"
_INSTANCE_TAG = (
    ("ctype", "prod"),
    ("geo", "msk"),
    ("prj", "imgs-cbir"),
    ("tier", "none")
)


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = resource_types.BASESEARCH_PLAN
    required = True


class ImagesTestCbirdaemon2Unistat(search_performance.OldShootingTask,
                                   search_yasm.YasmAgentTask,
                                   daemons_task.BaseCbirdaemonTask):
    """
        Verify unistat implementation in cbirdaemon
    """

    type = 'IMAGES_TEST_CBIRDAEMON2_UNISTAT'

    input_parameters = \
        (PlanParameter,) + \
        daemons_task.BaseCbirdaemonTask.input_parameters + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        search_yasm.YasmAgentTask.input_parameters

    def on_enqueue(self):
        daemons_task.BaseCbirdaemonTask.on_enqueue(self)
        self.create_resource(
            self.descr,
            self.__unistat_signals(),
            resource_types.BASESEARCH_UNISTAT_SIGNALS,
            arch=sandboxapi.ARCH_ANY
        )

    def on_execute(self):
        cbirdaemon = self._get_daemon()
        yasmagent = self._yasmagent(cbirdaemon, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)
        yasmlistener = self._yasmlistener(yasmagent, instance_type=_INSTANCE_TYPE, instance_tag=_INSTANCE_TAG)

        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        with cbirdaemon, yasmagent, yasmlistener:
            self._old_shoot(cbirdaemon, self.ctx[PlanParameter.name])
        yasmlistener.dump(self.__unistat_signals())

    def _get_queries_parameter(self):
        return PlanParameter

    def _set_yasm_config_options(self, config_object):
        config_object.set("options_unistat", "url", "remote_admin?action=mstat&level=-1")
        if config_object.has_section("options_apphost_unistat"):
            config_object.set("options_apphost_unistat", "url", "_golovan?level=-1")

    def __unistat_signals(self):
        return self.abs_path("unistat-signals.txt")


__Task__ = ImagesTestCbirdaemon2Unistat
