from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types
from sandbox.projects.common import profiling
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.images.daemons import task as daemons_task
from sandbox.projects.tank.load_resources import resources as tank_resources


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = resource_types.BASESEARCH_PLAN
    required = False


class ImagesTestNaildaemonPerformance(search_performance.OldShootingTask,
                                      profiling.ProfilingTask,
                                      daemons_task.BaseNaildaemonTask):
    """
        Benchmark for naildaemon
    """

    type = 'IMAGES_TEST_NAILDAEMON_PERFORMANCE'

    input_parameters = \
        (PlanParameter,) + \
        daemons_task.BaseNaildaemonTask.input_parameters + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        profiling.ProfilingTask.input_parameters

    def on_execute(self):
        thumbdaemon = self._get_daemon()
        self.init_search_component(thumbdaemon)

        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        self._profiling_init(thumbdaemon, self.__get_perf_data_path())
        with thumbdaemon:
            self._old_shoot(thumbdaemon, self.ctx[PlanParameter.name])
        self._profiling_report(thumbdaemon, self.__get_perf_data_path())

    def _get_queries_parameter(self):
        return PlanParameter

    # standard hook for massiff and sanitizer task generators
    def init_search_component(self, component):
        pass

    def __get_perf_data_path(self, recreate=False):
        return self.abs_path("perf.data")


__Task__ = ImagesTestNaildaemonPerformance
