from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops


class DaemonResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = get_current_images_devops('anskor', 'robot-images-sandbox', 'robot-testenv', 'matsuk', 'volynkin', 'woxalex', 'sind', 'polushkin', 'fedorets', 'ai3282', 'meow', 'esnesgovorov')


# Nail daemon


class NAIL_DAEMON_EXECUTABLE(DaemonResource):
    """
        Thumb daemon executable
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/daemons/naildaemon/naildaemon'


class NAIL_DAEMON_EXECUTABLE_STAGING(NAIL_DAEMON_EXECUTABLE):
    """
        Thumb daemon executable for staging
    """
    pass


class NAIL_DAEMON_CONFIG(DaemonResource):
    """
        Thumb daemon configuration (production)
    """
    arcadia_path = 'extsearch/images/daemons/naildaemon/production-configs/thumb.cfg'


class NAIL_DAEMON_CONFIG_STAGING(NAIL_DAEMON_CONFIG):
    """
        Thumb daemon configuration (staging)
    """
    pass


# RIM daemon


class IMAGES_RIM_DAEMON_EXECUTABLE(DaemonResource):
    """
        Rim daemon executable
    """
    any_arch = False
    executable = True
    releasers = DaemonResource.releasers + ['kigan']
    arcadia_build_path = 'extsearch/images/daemons/rimdaemon/rimdaemon'


class IMAGES_RIM_DAEMON_CONFIG(DaemonResource):
    """
        Config of rim daemon
    """
    releasers = DaemonResource.releasers + ['kigan']
    arcadia_path = 'extsearch/images/daemons/rimdaemon/config/rim.conf'


class IMAGES_RIM_RESPONSES(sdk2.Resource):
    """
        Rim responses
    """
    auto_backup = True


class IMAGES_RIM_RESPONSES_DIFF(sdk2.Resource):
    """
        Rim responses diff
    """
    auto_backup = True


class IMAGES_RIM_RESPONSES_URLS(sdk2.Resource):
    """
        Rim responses as pair urls for source image and related image in tsv format
    """
    auto_backup = True


class IMAGES_RIM_RESPONSES_DUP_URLS(sdk2.Resource):
    """
        Rim responses as urls for source and related images duplicates in json format
    """
    auto_backup = True


class IMAGES_RIMPATCH_DAEMON_EXECUTABLE(DaemonResource):
    """
        Rim patch daemon executable
    """
    any_arch = False
    executable = True
    releasers = DaemonResource.releasers + ['kigan']
    arcadia_build_path = 'extsearch/images/daemons/rimpatchdaemon/rimpatchdaemon'


class IMAGES_RIMPATCH_DAEMON_CONFIG(DaemonResource):
    """
        Config of rim patch daemon
    """
    releasers = DaemonResource.releasers + ['kigan']
    arcadia_path = 'extsearch/images/daemons/rimpatchdaemon/config/rimpatch.conf'


class IMAGES_RIMPATCH_DAEMON_BAN_ARCHIVE(sdk2.resource.AbstractResource):
    """
        gzip file with ban files
    """


class IMAGES_RIMPATCHDAEMON_APPHOST_RESPONSES(sdk2.Resource):
    """
        rim patch daemon responses (apphost)
    """
    auto_backup = True


class IMAGES_RIMPATCHDAEMON_APPHOST_RESPONSES_DIFF(sdk2.Resource):
    """
        rim patch daemon responses (apphost)
    """
    auto_backup = True


# CBIR daemon


class CBIR_DAEMON2_CLEAN_EXECUTABLE(DaemonResource):
    """
        Cbir daemon executable w/o cflags
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/daemons/cbirdaemon2/cbirdaemon2'


class CBIR_DAEMON2_EXECUTABLE(CBIR_DAEMON2_CLEAN_EXECUTABLE):
    """
        Cbir daemon executable for cpu
    """
    build_def_flags = "-DTENSORFLOW_OLD"
    arcadia_build_path = 'extsearch/images/daemons/cbirdaemon2/cbirdaemon2'


class CBIR_DAEMON2_FPGA_EXECUTABLE(CBIR_DAEMON2_CLEAN_EXECUTABLE):
    """
        Cbir daemon executable for fpga
    """
    build_def_flags = "-DUSE_FPGA"
    arcadia_build_path = 'extsearch/images/daemons/cbirdaemon2_fpga/cbirdaemon2_fpga'


class CBIR_DAEMON2_GPU_EXECUTABLE(CBIR_DAEMON2_CLEAN_EXECUTABLE):
    """
        Cbir daemon executable for gpu
    """
    build_def_flags = "-DTENSORFLOW_WITH_CUDA -DCUDA_VERSION=11.0 -DTENSORRT_VERSION=7 -DOS_SDK=ubuntu-16 -DCUDNN_VERSION=8.0.5 -DCUDNN_DYNAMIC"
    arcadia_build_path = 'extsearch/images/daemons/cbirdaemon2/cbirdaemon2'


class CBIR_DAEMON2_OMP_EXECUTABLE(CBIR_DAEMON2_CLEAN_EXECUTABLE):
    """
        Cbir daemon executable for mkldnn+openmp
    """
    build_def_flags = "-DTENSORFLOW_OLD -DMKLDNN_OPENMP_SUPPORT"
    arcadia_build_path = 'extsearch/images/daemons/cbirdaemon2/cbirdaemon2'


class CBIR_DAEMON2_EXECUTABLE_STAGING(CBIR_DAEMON2_EXECUTABLE):
    """
        Cbir daemon executable for staging
    """
    pass


class CBIR_DAEMON2_CONFIG(DaemonResource):
    """
        Cbir daemon configuration (production)
    """
    build_def_flags = "-DTENSORFLOW_OLD"
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/cbirdaemon.conf'


class CBIR_DAEMON2_FPGA_CONFIG(DaemonResource):
    """
        Cbir daemon configuration for fpga (production)
    """
    build_def_flags = "-DUSE_FPGA"
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/cbirdaemon_fpga.conf'


class CBIR_DAEMON2_GPU_CONFIG(DaemonResource):
    """
        Cbir daemon configuration for GPU (production)
    """
    build_def_flags = "-DTENSORFLOW_WITH_CUDA -DCUDA_VERSION=11.0 -DTENSORRT_VERSION=7 -DOS_SDK=ubuntu-16 -DCUDNN_VERSION=8.0.5 -DCUDNN_DYNAMIC"
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/cbirdaemon_gpu.conf'


class CBIR_DAEMON2_OMP_CONFIG(DaemonResource):
    """
        Cbir daemon configuration for MKLDNN+OPENMP (production)
    """
    build_def_flags = "-DTENSORFLOW_OLD -DMKLDNN_OPENMP_SUPPORT"
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/cbirdaemon.conf'


class CBIR_DAEMON2_API_CONFIG(DaemonResource):
    """
        Cbir daemon configuration for external api (production)
    """
    build_def_flags = "-DTENSORFLOW_OLD"
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/cbirdaemon_api.conf'


class CBIR_DAEMON2_API_GPU_CONFIG(CBIR_DAEMON2_GPU_CONFIG):
    """
        Cbir daemon configuration for external api GPU (production)
    """
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/cbirdaemon_api_gpu.conf'


class CBIR_DAEMON2_CONFIG_STAGING(CBIR_DAEMON2_CONFIG):
    """
        Cbir daemon configuration (production)
    """
    pass


class CBIR_DAEMON2_SETTINGS(DaemonResource):
    """
        All configuration files and data for cbirdaemon2
    """
    generate_path = 'cbirdaemon'
    shard_instance = sdk2.Attributes.String("shard_instance", required=False)
    shard_instance_prefix = 'cbirdaemon'
    arcadia_dir = 'imgcbrd'


class CBIR_DAEMON2_FPGA_SETTINGS(CBIR_DAEMON2_SETTINGS):
    """
        All configuration files and data for cbirdaemon2 FPGA
    """
    shard_instance_prefix = 'cbirdaemon_fpga'


class CBIR_DAEMON2_GPU_SETTINGS(CBIR_DAEMON2_SETTINGS):
    """
        All configuration files and data for cbirdaemon2 GPU
    """
    shard_instance_prefix = 'cbirdaemon_gpu'
    arcadia_dir = 'imgcbrd_gpu'


class CBIR_DAEMON2_API_SETTINGS(CBIR_DAEMON2_SETTINGS):
    """
        All configuration files and data for cbirdaemon2 external api
    """
    shard_instance_prefix = 'cbirdaemon_api'
    arcadia_dir = 'imgcbrd_ext'


class CBIR_DAEMON2_GPU_API_SETTINGS(CBIR_DAEMON2_SETTINGS):
    """
        All configuration files and data for cbirdaemon2 GPU external api
    """
    shard_instance_prefix = 'cbirdaemon_gpu_api'
    arcadia_dir = 'imgcbrd_gpu_ext'


class CBIR_DAEMON2_RESPONSES(sdk2.Resource):
    """
        Cbirdaemon responses (post)
    """
    auto_backup = True


class CBIR_DAEMON2_APPHOST_RESPONSES(sdk2.Resource):
    """
        Cbirdaemon responses (apphost)
    """
    auto_backup = True


class CBIR_DAEMON2_RESPONSES_DIFF(sdk2.Resource):
    """
        Diff between cbirdaemon responses (post)
    """
    auto_backup = True


class CBIR_DAEMON2_APPHOST_RESPONSES_DIFF(sdk2.Resource):
    """
        Diff between cbirdaemon responses (apphost)
    """
    auto_backup = True


# Commercial daemon

class IMAGES_COMMERCIAL_DAEMON_EXECUTABLE(DaemonResource):
    """
        Commercial daemon executable
    """
    any_arch = False
    executable = True
    releasers = DaemonResource.releasers + ['evseevd']
    arcadia_build_path = 'extsearch/images/daemons/commercialdaemon/commercialdaemon'


class IMAGES_COMMERCIAL_DAEMON_CONFIG(DaemonResource):
    """
        Config of commercial daemon
    """
    releasers = DaemonResource.releasers + ['evseevd']
    arcadia_path = 'extsearch/images/daemons/commercialdaemon/config/commercial.conf'


class IMAGES_COMMERCIAL_DAEMON_HAMSTER_CONFIG(DaemonResource):
    """
        Config of hamster commercial daemon
    """
    releasers = DaemonResource.releasers + ['evseevd']
    arcadia_path = 'extsearch/images/daemons/commercialdaemon/config/commercial_hamster.conf'

    def get_arts(self):
        return [{'path': self.arcadia_path, 'dest': 'commercial.conf'}]


class IMAGES_COMMERCIAL_DAEMON_PIP_CONFIG(DaemonResource):
    """
        Config of pip commercial daemon
    """
    releasers = DaemonResource.releasers + ['evseevd']
    arcadia_path = 'extsearch/images/daemons/commercialdaemon/config/commercial_pip.conf'

    def get_arts(self):
        return [{'path': self.arcadia_path, 'dest': 'commercial.conf'}]


class IMAGES_COMMERCIAL_DAEMON_CATEGORIES(DaemonResource):
    """
        List of specific market categories to filter on
    """
    releasers = DaemonResource.releasers + ['evseevd', 'robot-images-money']
    arcadia_path = 'extsearch/images/daemons/commercialdaemon/config/categories.txt'


class IMAGES_COMMERCIAL_DAEMON_CATEGORIES_BLACKLIST(sdk2.Resource):
    """
        List of specific market categories to exclude from filtration
    """
    releasable = True
    releasers = DaemonResource.releasers + ['anoh', 'shashkin', 'robot-images-money']


# LikesAgggregate daemon

class LIKES_AGGREGATE_DAEMON_EXECUTABLE(DaemonResource):
    """
        Likes daemon executable
    """
    any_arch = False
    executable = True
    releasers = DaemonResource.releasers + ['foxxmary']
    arcadia_build_path = 'extsearch/images/daemons/likesdaemon/likesdaemon'


class LIKES_AGGREGATE_DAEMON_CONFIG(DaemonResource):
    """
        Config of likes daemon
    """
    releasers = DaemonResource.releasers + ['foxxmary']
    arcadia_path = 'extsearch/images/daemons/likesdaemon/config/conf.conf'
