# -*- coding: utf-8 -*-

from sandbox.projects.MediaLib import FetchOcspResponse as OCSP_TASK
from sandbox.projects.images.deployment import resources as deployment_resources

SVN_CERT_PATH = \
    'svn+ssh://arcadia.yandex.ru/robots/trunk/genconf/resources/media-searches/images/rim/certs'
NANNY_DASHBOARD_NAME = 'images_runtime'
NANNY_DASHBOARD_FILTER = 'rim_balancer_prod'
NANNY_DASHBOARD_RECIPE = 'rim_deploy_ocsp'


class ImagesRimFetchOcspResponse(OCSP_TASK.FetchOcspResponse):
    """
    Generate ocsp response files for Ya.Images RIM balancers
    """
    type = 'IMAGES_RIM_FETCH_OCSP_RESPONSE'

    @staticmethod
    def _get_ocsp_resource_type():
        return deployment_resources.IMAGES_RIM_OCSP_RESPONSE_FILES

    def initCtx(self):
        # override inputs
        self.ctx[OCSP_TASK.CertSvnUrlParameter.name] = SVN_CERT_PATH
        self.ctx[OCSP_TASK.DashboardName.name] = NANNY_DASHBOARD_NAME
        self.ctx[OCSP_TASK.DashboardFilter.name] = NANNY_DASHBOARD_FILTER
        self.ctx[OCSP_TASK.DashboardRecipe.name] = NANNY_DASHBOARD_RECIPE


__Task__ = ImagesRimFetchOcspResponse
