from sandbox import sdk2

multsearch = ['robot-images']


class ShardmapResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = [
        'anskor', 'kigan', 'shashkin',
        'robot-images-sandbox', 'robot-images'
    ]
    release_subscribers = ['images-releases']


class LoopConfResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = [
        'anskor', 'kigan', 'shashkin', 'alekseyzotov',
        'robot-images-sandbox', 'robot-images'
    ]
    release_subscribers = ['images-releases']


class IMAGES_RQ_SHARDMAP(ShardmapResource):
    """
        Related queries
    """
    releasers = ['pupatenko', 'robot-imgrq'] + ShardmapResource.releasers


class IMAGES_RIM_SHARDMAP(ShardmapResource):
    """
        Related images (RIM)
    """
    pass


class IMAGES_LARGE_THUMB_SHARDMAP(ShardmapResource):
    """
        Large thumbnails
    """
    pass


class IMAGES_COMMERCIAL_SHARDMAP(ShardmapResource):
    """
        Commercial base
    """
    releasers = ShardmapResource.releasers + ['anoh', 'shashkin', 'robot-images-money']
    release_subscribers = ShardmapResource.release_subscribers


class IMAGES_RQ_MMETA_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - Images RQ service
    """
    pass


class IMAGES_MAIN_BASE_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - imgsearch (main)
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/main-loop.cfg'


class IMAGES_GARBAGE_BASE_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - imgsearch (main)
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/garbage-loop.cfg'


class IMAGES_QUICK_BASE_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - imgsearch (quick)
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/quick-loop.cfg'


class IMAGES_CBIRDAEMON_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - cbirdaemon
    """
    arcadia_path = 'extsearch/images/daemons/cbirdaemon2/prod_configs/loop.conf'


class IMAGES_NAILDAEMON_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - naildaemon
    """
    arcadia_path = 'extsearch/images/daemons/naildaemon/production-configs/loop.conf'


class IMAGES_MMETA_LOOP_CONFIG(LoopConfResource):
    """
        Configuration file for instancectl - Images service
    """
    pass


class IMAGES_INSTANCESEL(LoopConfResource):
    """
        Helper tool to select random tag and instance
    """

    executable = True
    arcadia_build_path = 'extsearch/images/tools/instancesel/instancesel'


class IMAGES_THUMB_OCSP_RESPONSE_FILES(sdk2.Resource):
    """
        Tarball with ocsp responses thumbnail certs
    """
    releasable = True
    releasers = multsearch


class IMAGES_THUMB_PRESTABLE_OCSP_RESPONSE_FILES(sdk2.Resource):
    """
        Tarball with ocsp responses thumbnail certs
    """
    releasable = True
    releasers = multsearch


class IMAGES_RIM_OCSP_RESPONSE_FILES(sdk2.Resource):
    """
        Tarball with ocsp responses rim certs
    """
    releasable = True
    releasers = multsearch


class IMAGES_CHECK_DEPENDENCIES_SCRIPT(LoopConfResource):
    """
        IMGDEVOPS-238: make possible to depends on instance to another
    """
    arcadia_path = 'extsearch/images/base/imgsearch/configs/check_dependencies.py'
