# -*- coding: utf-8 -*-

import resources as devops_resources

from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params


class ImagesBuildDevopsBinaries(BaseMediaBuildTask):
    """
        Images devops binaries
    """

    type = 'IMAGES_BUILD_DEVOPS_BINARIES'
    execution_space = 120000

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            devops_resources.INDEX_SNAPSHOT_CLEANER_EXECUTABLE
        )

    def get_configs(self):
        return (
            devops_resources.INDEX_SNAPSHOT_CLEANER_CONFIG
        )


__Task__ = ImagesBuildDevopsBinaries
