from sandbox import sdk2

from sandbox.projects.images.resource_types import images_releasers


images_devops_releasers = images_releasers + []
images_devops_subscribers = images_devops_releasers + []


class ImagesDevopsResource(sdk2.Resource):
    auto_backup = True
    releasers = images_devops_releasers
    release_subscribers = images_devops_subscribers


class INDEX_SNAPSHOT_CLEANER_EXECUTABLE(ImagesDevopsResource):
    """
        Index snapshot cleaner executable
    """
    any_arch = False
    executable = True
    releasable = True
    arcadia_build_path = 'extsearch/images/robot/tools/index_snapshot_cleaner/index_snapshot_cleaner'


class INDEX_SNAPSHOT_CLEANER_CONFIG(ImagesDevopsResource):
    """
        Index snapshot cleaner config
    """
    releasable = True
    arcadia_path = 'extsearch/images/robot/tools/index_snapshot_cleaner/config.json'

