# -*- coding: utf-8 -*-

from sandbox.projects.images.duck.ImagesDuckCmPackageBase import StripBinariesParameter
from sandbox.projects.images.duck.ImagesDuckCmPackageBase import ImagesDuckCmPackageBase
from sandbox.projects.images.duck import resources
import sandbox.projects.common.build.parameters as build_params
from sandbox.sandboxsdk import parameters
from sandbox.projects.common.build import YaPackage


class ImagesDuckCmPackageParameter(YaPackage.PackagesParameter):
    default_value = 'extsearch/images/duck/packages/cm.json'


class ImagesDuckCmPackageTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = resources.IMAGES_DUCK_CM_CM_PACKAGE.name


class ImagesDuckBuildCmCmPackage(ImagesDuckCmPackageBase):
    type = 'IMAGES_DUCK_BUILD_CM_CM_PACKAGE'

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        ImagesDuckCmPackageParameter,
        ImagesDuckCmPackageTypeParameter,
        build_params.ArcadiaPatch,
        StripBinariesParameter,
    )


__Task__ = ImagesDuckBuildCmCmPackage
