# -*- coding: utf-8 -*-

from sandbox.projects.images.duck.ImagesDuckCmPackageBase import StripBinariesParameter
from sandbox.projects.images.duck.ImagesDuckCmPackageBase import ImagesDuckCmPackageBase
from sandbox.projects.images.duck import resources
import sandbox.projects.common.build.parameters as build_params
from sandbox.sandboxsdk import parameters
from sandbox.projects.common.build import YaPackage


class ImagesDuckRobotPackageParameter(YaPackage.PackagesParameter):
    default_value = 'extsearch/images/duck/packages/cm_robot.json'


class ImagesDuckRobotPackageTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = resources.IMAGES_DUCK_CM_ROBOT_PACKAGE.name


class ImagesDuckBuildCmRobotPackage(ImagesDuckCmPackageBase):
    type = 'IMAGES_DUCK_BUILD_CM_ROBOT_PACKAGE'

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        ImagesDuckRobotPackageParameter,
        ImagesDuckRobotPackageTypeParameter,
        build_params.ArcadiaPatch,
        StripBinariesParameter,
    )


__Task__ = ImagesDuckBuildCmRobotPackage
