# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.nanny import auto_deploy
from sandbox.sdk2 import yav


class StripBinariesParameter(YaPackage.StripBinariesParameter):
    default_value = True


class ImagesDuckCmPackageBase(YaPackage.YaPackage, auto_deploy.AutoNannyDeployTask):
    __STABLE_SERVICES = ['images_duck_clustermaster']
    __TESTING_SERVICES = []

    type = 'IMAGES_DUCK_CM_PACKAGE_BASE'
    client_tags = ctc.Tag.SSD
    execution_space = 200 * 1024

    def on_enqueue(self):
        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        self.ctx.update({YaPackage.PackageTypeParameter.name: YaPackage.TARBALL})
        self.ctx.update({YaPackage.PublishPackageParameter.name: False})
        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        YaPackage.YaPackage.on_release(self, additional_parameters)
        auto_deploy.AutoNannyDeployTask.on_release(self, additional_parameters)

    def get_nanny_oauth_token(self):
        return yav.Secret("sec-01dvzzxmzwwegmmsqtq6rndvcb").data()["secret"]

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES
