# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.images.resources.devops import get_current_images_devops


class ImagesDuckReleasableResource(sdk2.Resource):
    auto_backup = True
    release_subscribers = ['pupatenko', 'robot-imgrq']
    releasable = True
    releasers = get_current_images_devops('krivokon', 'pupatenko', 'robot-imgrq', 'robot-images-sandbox')


class IMAGES_DUCK_CM_ROBOT_PACKAGE(ImagesDuckReleasableResource):
    """
        Images-duck clustermaster: robot binaries package
    """
    any_arch = False


class IMAGES_DUCK_CM_SCRIPTS_PACKAGE(ImagesDuckReleasableResource):
    """
        Images-duck clustermaster: clustermaster scripts package
    """
    any_arch = True


class IMAGES_DUCK_CM_CM_PACKAGE(ImagesDuckReleasableResource):
    """
        Images-duck clustermaster: clustermaster binaries package
    """
    any_arch = False
