import logging
import time
from sandbox import sdk2
from sandbox.common.rest import Client as SandboxClient
from sandbox.projects.images.common import SearchTaskCommonParameters
from sandbox.projects.images.embedding import EMBEDDING_STORAGE
from sandbox.projects.images.embedding.task import EDaemonComponentTask
from sandbox.projects.images.inverted_index import INVERTED_INDEX
from sandbox.projects.images.inverted_index.task import PDaemonComponentTask
from sandbox.projects.common import network


class ImagesRunStandaloneEDaemon(sdk2.Task, EDaemonComponentTask, PDaemonComponentTask):
    """
        Run standalone inverted index (P-daemon)
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = EMBEDDING_STORAGE.DEFAULT_SHARD_SIZE
        ram = EMBEDDING_STORAGE.DEFAULT_SHARD_SIZE

    class Context(sdk2.Task.Context):
        finish_request = False
        network_address = None

    class Parameters(sdk2.Parameters):
        index_state = SearchTaskCommonParameters.Parameters.index_state()
        partition_number = SearchTaskCommonParameters.Parameters.partition_number()
        search_l1_models_archive = SearchTaskCommonParameters.Parameters.search_l1_models_archive()
        edaemon_parameters = EDaemonComponentTask.Parameters()
        pdaemon_parameters = PDaemonComponentTask.Parameters()

    def on_enqueue(self):
        PDaemonComponentTask.on_enqueue(self)
        EDaemonComponentTask.on_enqueue(self)
        self.Requirements.disk_space = EMBEDDING_STORAGE.DEFAULT_SHARD_SIZE + len(self.Parameters.pdaemon_parameters.shards_number)*INVERTED_INDEX.DEFAULT_SHARD_SIZE
        self.Requirements.ram = EMBEDDING_STORAGE.DEFAULT_SHARD_SIZE + len(self.Parameters.pdaemon_parameters.shards_number)*INVERTED_INDEX.DEFAULT_SHARD_SIZE

    def on_execute(self):
        PDaemonComponentTask.init_resources(self)
        EDaemonComponentTask.init_resources(self)
        self.Context.network_address = network.get_my_ipv6()
        self.Context.save()

        PDaemonComponentTask.on_execute(self)
        EDaemonComponentTask.on_execute(self)

        client = SandboxClient()
        while True:
            if self.Context.finish_request is True:
                break

            if self.parent:
                if client.task[self.parent.id].read()['status'] != "EXECUTING":
                    logging.info("Parent task finished")
                    break

            if self.edaemon_process_id.poll() is not None:
                if self.edaemon_process_id.returncode is not 0:
                    raise Exception("Error", "Subprocess exit code is {}".format(self.edaemon_process_id.returncode))

            time.sleep(6)
