import logging
import time
from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.images.common import SearchTaskCommonParameters
from sandbox.projects.common import profiling2 as search_profiling
from sandbox.projects.common.search import performance2 as search_performance
from sandbox.projects.images.embedding import EMBEDDING_STORAGE
from sandbox.projects.images.embedding.task import EDaemonComponentTask
from sandbox.projects.images.inverted_index.task import PDaemonComponentTask
from sandbox.projects.common import network

class EmbeddingStorageComponent:
    class process:
        pid = None
    port = EMBEDDING_STORAGE.DEFAULT_PORT


class ImagesTestEmbeddingStoragePerformance(sdk2.Task,
                                            EDaemonComponentTask,
                                            PDaemonComponentTask,
                                            search_performance.OldShootingTask,
                                            search_profiling.ProfilingTask):
    """
        Test embedding storage performance
    """

    class Parameters(sdk2.Parameters):
        custom_settings = sdk2.parameters.Bool("Use custom partition configuration", default_value=False)
        index_state = SearchTaskCommonParameters.Parameters.index_state()
        partition_number = SearchTaskCommonParameters.Parameters.partition_number()
        search_l1_models_archive = SearchTaskCommonParameters.Parameters.search_l1_models_archive()
        edaemon_parameters = EDaemonComponentTask.Parameters()
        pdaemon_parameters = PDaemonComponentTask.Parameters()

        profiling = search_profiling.ProfilingTask.Parameters()
        shooting = search_performance.OldShootingTask.Parameters()

        plan = sdk2.parameters.Resource('Embedding storage requests (d-executor plan)',
                                        resource_type=resource_types.BASESEARCH_PLAN,
                                        required=True)

    def on_enqueue(self):
        if not self.Parameters.custom_settings:
            self.Parameters.pdaemon_parameters.shards_number = range(EMBEDDING_STORAGE.DEFAULT_SOURCES_NUM)
            self.Parameters.pdaemon_parameters.use_entire_partition = False

        PDaemonComponentTask.on_enqueue(self)
        EDaemonComponentTask.on_enqueue(self)

    def on_execute(self):
        PDaemonComponentTask.init_resources(self)
        EDaemonComponentTask.init_resources(self)

        PDaemonComponentTask.on_execute(self)
        EDaemonComponentTask.on_execute(self)

        embedding_storage_component = EmbeddingStorageComponent()
        embedding_storage_component.process.pid = self.edaemon_process_id.pid

        self._init_virtualenv()
        self._profiling_init(embedding_storage_component, self.__get_perf_data_path())
        self._old_shoot(embedding_storage_component, self.Parameters.plan)
        self._profiling_report(embedding_storage_component, self.__get_perf_data_path())

    def _get_queries_parameter(self):
        return self.Parameters.plan

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        if "max_rps" in self.ctx:
            return "{:0.2f}".format(self.ctx["max_rps"])

    def __get_perf_data_path(self, recreate=False):
        return self.path("perf.data")
