# -*- coding: utf-8 -*-

from sandbox.projects.images.guppy import resources as guppy_resources
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as constants
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.nanny import auto_deploy

class ImagesBuildGuppyResources(BaseMediaBuildTask, auto_deploy.AutoNannyDeployTask):
    """
       Resources for guppy
    """

    type = 'IMAGES_BUILD_GUPPY_RESOURCES'
    execution_space = 30 * 1024

    __STABLE_SERVICES = ['production_guppy_quick',
                         'production_guppy_ultra',
                         'production_guppy_v10',
                         'production_guppy_upscale']
    __TESTING_SERVICES = []


    def initCtx(self):
        self.ctx[constants.BUILD_BUNDLE_KEY] = False
        self.ctx[constants.DEFINITION_FLAGS_KEY] = '-DTENSORFLOW_WITH_CUDA -DCUDA_VERSION=10.1 -DTENSORFLOW_WITH_XLA'
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            guppy_resources.IMAGES_GUPPY_EXECUTABLE,
        )

    def get_configs(self):
        return (guppy_resources.IMAGES_GUPPY_CONFIG_HTTP,
                guppy_resources.IMAGES_GUPPY_CONFIG_PQ_V10,
                guppy_resources.IMAGES_GUPPY_CONFIG_PQ_UPSCALE,
                guppy_resources.IMAGES_GUPPY_CONFIG_PQ_QUICK,
                guppy_resources.IMAGES_GUPPY_CONFIG_PQ_QUICK_ACCEPT,
                guppy_resources.IMAGES_GUPPY_CONFIG_PQ_ULTRA,
                guppy_resources.IMAGES_GUPPY_CONFIG_PQ_DETECTION_BIG_THUMBS_DTCMP,
                guppy_resources.IMAGES_GUPPY_CONFIG_SOLOMON_V10,
                guppy_resources.IMAGES_GUPPY_CONFIG_SOLOMON_UPSCALE,
                guppy_resources.IMAGES_GUPPY_CONFIG_SOLOMON_QUICK,
                guppy_resources.IMAGES_GUPPY_CONFIG_SOLOMON_QUICK_ACCEPT,
                guppy_resources.IMAGES_GUPPY_CONFIG_SOLOMON_ULTRA,
                guppy_resources.IMAGES_GUPPY_CONFIG_SOLOMON_DETECTION_BIG_THUMBS_DTCMP,
                guppy_resources.IMAGES_GUPPY_CONFIG_TENSORFLOW_V10,
                guppy_resources.IMAGES_GUPPY_CONFIG_TENSORFLOW_UPSCALE,
                guppy_resources.IMAGES_GUPPY_CONFIG_TENSORFLOW_FRESH,
                guppy_resources.IMAGES_GUPPY_CONFIG_TENSORFLOW_QUICK_ACCEPT,
                guppy_resources.IMAGES_GUPPY_CONFIG_TENSORFLOW_DETECTION_BIG_THUMBS_DTCMP,
                guppy_resources.IMAGES_GUPPY_LOOP_CONFIG,
                guppy_resources.IMAGES_GUPPY_LOOP_PASS_THROUGH_CONFIG,
       )

    def on_release(self, additional_parameters):
        BaseMediaBuildTask.on_release(self, additional_parameters)
        auto_deploy.AutoNannyDeployTask.on_release(self, additional_parameters)

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')

    def get_stable_services(self):
        return self.__STABLE_SERVICES

    def get_testing_services(self):
        return self.__TESTING_SERVICES


__Task__ = ImagesBuildGuppyResources
