from sandbox import sdk2

images_guppy_releasers = [
    'vitamin-ca',
    'igorluk',
    'ulgen4a',
    'robot-images-sandbox',
]

images_guppy_subscribers = images_guppy_releasers + []


class ImagesGuppyResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = images_guppy_releasers
    release_subscribers = images_guppy_subscribers


class IMAGES_GUPPY_EXECUTABLE(ImagesGuppyResource):
    """
       Guppy executable
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/images/robot/guppy/app/guppy'


class IMAGES_GUPPY_CONFIG_HTTP(ImagesGuppyResource):
    """
       Config for HTTP server
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/http.conf'


class IMAGES_GUPPY_CONFIG_PQ_V10(ImagesGuppyResource):
    """
       Config for PQ source/target
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/pq_v10.conf'


class IMAGES_GUPPY_CONFIG_PQ_UPSCALE(ImagesGuppyResource):
    """
       Config for PQ source/target for upscale processing
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/pq_upscale.conf'


class IMAGES_GUPPY_CONFIG_PQ_QUICK(ImagesGuppyResource):
    """
       Config for PQ source/target for quick
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/pq_quick.conf'


class IMAGES_GUPPY_CONFIG_PQ_QUICK_ACCEPT(ImagesGuppyResource):
    """
       Config for PQ source/target for quick
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/pq_quick_accept.conf'


class IMAGES_GUPPY_CONFIG_PQ_ULTRA(ImagesGuppyResource):
    """
       Config for PQ source/target for ultra
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/pq_ultra.conf'


class IMAGES_GUPPY_CONFIG_PQ_DETECTION_BIG_THUMBS_DTCMP(ImagesGuppyResource):
    """
       Config for PQ source/target for guppy-detection-big-thumbs dtcmp
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/pq_detection_big_thumbs_dtcmp.conf'


class IMAGES_GUPPY_CONFIG_SOLOMON_V10(ImagesGuppyResource):
    """
       Config for Solomon statistics
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/solomon_v10.conf'


class IMAGES_GUPPY_CONFIG_SOLOMON_UPSCALE(ImagesGuppyResource):
    """
       Config for Solomon statistics
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/solomon_upscale.conf'


class IMAGES_GUPPY_CONFIG_SOLOMON_QUICK(ImagesGuppyResource):
    """
       Solomon statistics config for quick
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/solomon_quick.conf'


class IMAGES_GUPPY_CONFIG_SOLOMON_QUICK_ACCEPT(ImagesGuppyResource):
    """
       Solomon statistics config for quick
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/solomon_quick_accept.conf'


class IMAGES_GUPPY_CONFIG_SOLOMON_ULTRA(ImagesGuppyResource):
    """
       Solomon statistics config for ultra
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/solomon_ultra.conf'


class IMAGES_GUPPY_CONFIG_SOLOMON_DETECTION_BIG_THUMBS_DTCMP(ImagesGuppyResource):
    """
       Solomon statistics config for guppy-detection-big-thumbs dtcmp
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/solomon_detection_big_thumbs_dtcmp.conf'


class IMAGES_GUPPY_CONFIG_TENSORFLOW_V10(ImagesGuppyResource):
    """
       Config for TF processing (NN body not included!)
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/tensorflow_v10.conf'


class IMAGES_GUPPY_CONFIG_TENSORFLOW_UPSCALE(ImagesGuppyResource):
    """
       Config for TF processing (NN body not included!)
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/tensorflow_upscale.conf'


class IMAGES_GUPPY_CONFIG_TENSORFLOW_FRESH(ImagesGuppyResource):
    """
       Config for TF processing (NN body not included!) Fresh
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/tensorflow_fresh.conf'


class IMAGES_GUPPY_CONFIG_TENSORFLOW_QUICK_ACCEPT(ImagesGuppyResource):
    """
       Config for TF processing (NN body not included!) Fresh
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/tensorflow_quick_accept.conf'


class IMAGES_GUPPY_CONFIG_TENSORFLOW_DETECTION_BIG_THUMBS_DTCMP(ImagesGuppyResource):
    """
       Config for TF processing guppy-detection-big-thumbs dtcmp
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/tensorflow_detection_big_thumbs_dtcmp.conf'


class IMAGES_GUPPY_LOOP_CONFIG(ImagesGuppyResource):
    """
       Loop script for Nanny
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/loop.conf'


class IMAGES_GUPPY_LOOP_PASS_THROUGH_CONFIG(ImagesGuppyResource):
    """
       Loop script for Nanny (with enable pass through mode)
    """
    arcadia_path = 'extsearch/images/robot/guppy/dist/loop_pass_through.conf'
