from sandbox.projects import resource_types
from sandbox.projects.common.search import idx_ops
from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.images.idx_ops import resources as images_idx_ops_resources


_PARAMS = idx_ops.create_input_parameters(
    images_idx_ops_resources.IDX_OPS_IMAGES_EXECUTABLE,
    resource_types.IMAGES_SEARCH_DATABASE,
    database_required=False,
)


class ImagesGetIdxOpsResponses(idx_ops.BaseGetIdxOpsResponses):
    """
        Aquire responses from idx_ops tool in serp mode
    """

    type = 'IMAGES_GET_IDX_OPS_RESPONSES'

    input_parameters = _PARAMS.params + idx_ops.BaseGetIdxOpsResponses.input_parameters
    execution_space = 120 * 1024

    def on_enqueue(self):
        idx_ops.BaseGetIdxOpsResponses.on_enqueue(self)
        search_settings.ImagesSettings.ensure_search_database(
            self,
            idx_ops.QueriesParameter,
            _PARAMS.SearchDatabaseParameter
        )


__Task__ = ImagesGetIdxOpsResponses
