import sandbox.common.types.client as ctc

from sandbox.projects import RunIdxOpsEstFeatures as base_task
from sandbox.projects.common.search import settings as search_settings


class _SearchDatabaseResourceParameter(base_task.SearchDatabaseResourceParameter):
    required = False


class ImagesTestIdxOpsEstFeatures(base_task.RunIdxOpsEstFeatures):
    type = 'IMAGES_TEST_IDX_OPS_ESTFEATURES'

    input_parameters = [_SearchDatabaseResourceParameter] + [
        param for param in base_task.RunIdxOpsEstFeatures.input_parameters
        if param.name != base_task.SearchDatabaseResourceParameter.name
    ]

    execution_space = 130 * 1024
    client_tags = ctc.Tag.INTEL_E5_2660

    def on_enqueue(self):
        base_task.RunIdxOpsEstFeatures.on_enqueue(self)
        search_settings.ImagesSettings.ensure_search_database(
            self,
            base_task.RequestsParameter,
            base_task.SearchDatabaseResourceParameter
        )


__Task__ = ImagesTestIdxOpsEstFeatures
