import subprocess
import time
from sandbox import sdk2
from sandbox.projects.images.common import SearchTaskCommonParameters
from sandbox.projects.images.inverted_index.task import PDaemonComponentTask
from sandbox.projects.common import network


class ImagesRunStandalonePDaemon(sdk2.Task, PDaemonComponentTask):
    """
        Run standalone inverted index (P-daemon)
    """

    class Context(PDaemonComponentTask.Context):
        finish_request = False
        network_address = None

    class Parameters(sdk2.Parameters):
        index_state = SearchTaskCommonParameters.Parameters.index_state()
        partition_number = SearchTaskCommonParameters.Parameters.partition_number()
        pdaemon_parameters = PDaemonComponentTask.Parameters()

    def on_enqueue(self):
        PDaemonComponentTask.on_enqueue(self)

    def on_execute(self):
        PDaemonComponentTask.init_resources(self)

        self.Context.network_address = network.get_my_ipv6()
        self.Context.save()
        PDaemonComponentTask.on_execute(self)

        while True:
            if self.Context.finish_request is True:
                break

            for pid in self.pdaemon_process_ids:
                if pid.poll() is not None:
                    if pid.returncode is not 0:
                        raise Exception("Error", "Subprocess exit code is {}".format(pid.returncode))

            time.sleep(6)
