from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types

from sandbox.projects.websearch.middlesearch.PriemkaMiddlesearchBinary import PriemkaMiddlesearchBinary
from sandbox.projects.websearch.middlesearch.PriemkaMiddlesearchBinary import params as middlesearch_params


class ImagesAnalyzeMiddlesearchPerformance(PriemkaMiddlesearchBinary):
    """
        Analyze middlesearch performance
    """

    type = 'IMAGES_ANALYZE_MIDDLESEARCH_PERFORMANCE'

    class OldMiddlesearchShard(parameters.ResourceSelector):
        name = "index_resource_for_old_mmeta"
        description = "Old metasearch index"
        resource_type = resource_types.IMAGES_MIDDLESEARCH_INDEX
        required = True

    class NewMiddlesearchShard(parameters.ResourceSelector):
        name = "index_resource_for_new_mmeta"
        description = "New metasearch index"
        resource_type = resource_types.IMAGES_MIDDLESEARCH_INDEX
        required = True

    from sandbox.projects.websearch.middlesearch.PriemkaMiddlesearchBinary.params import BinType

    input_parameters = [
        BinType,
        OldMiddlesearchShard,
        NewMiddlesearchShard
    ]

    def on_execute(self):
        self.ctx[middlesearch_params.AcceptanceType.name] = middlesearch_params.AcceptanceType.METASEARCH_ACCEPTANCE
        self.ctx[middlesearch_params.CTX_LEVEL_TEMPLATE.format("mmeta")] = True
        self.ctx[middlesearch_params.CTX_LEVEL_TEMPLATE.format("int")] = False
        self.ctx[middlesearch_params.TestsToRun.TestResponses.name] = True
        self.ctx[middlesearch_params.TestsToRun.TestFunctional.name] = True
        self.ctx[middlesearch_params.TestsToRun.TestBinaries.name] = True
        self.ctx[middlesearch_params.TestsToRun.TestMemoryUsage.name] = True

        PriemkaMiddlesearchBinary.on_execute(self)


__Task__ = ImagesAnalyzeMiddlesearchPerformance
